/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rowset;

import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.files.AttachmentImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.ExternalLinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.HyperlinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.link.RegisteredLinkTypeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.revision.RevisionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.BaseGetWorkItemRowSetHandler;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class WorkItemFilesRowSetHandler
extends BaseGetWorkItemRowSetHandler {
    private final Map<Integer, Map<Date, Integer>> adds = new HashMap<Integer, Map<Date, Integer>>();
    private final Map<Integer, Map<Date, Integer>> removes = new HashMap<Integer, Map<Date, Integer>>();

    public WorkItemFilesRowSetHandler(WorkItemImpl workItem, IMetadata metadataManager) {
        super(workItem, metadataManager);
    }

    @Override
    protected void doHandleRow() {
        int fieldId = this.getIntValue("FldID");
        Date removedDate = this.getDateValue("RemovedDate");
        Date addedDate = this.getDateValue("AddedDate");
        this.incrementCount(this.adds, fieldId, addedDate);
        if (removedDate != null) {
            this.incrementCount(this.removes, fieldId, removedDate);
            return;
        }
        if (fieldId == 50) {
            AttachmentImpl attachment = new AttachmentImpl(addedDate, this.getDateValue("CreationDate"), this.getDateValue("LastWriteDate"), this.getStringValue("OriginalName"), this.getStringValue("Comment"), this.getIntValue("Length"), this.getIntValue("ExtID"));
            this.getWorkItem().getAttachmentsInternal().add(attachment);
        } else if (fieldId == 51) {
            HyperlinkImpl link = new HyperlinkImpl(this.getStringValue("FilePath"), this.getStringValue("Comment"), this.getIntValue("ExtID"), false, false);
            this.getWorkItem().getLinksInternal().add(link);
        } else if (fieldId == 58) {
            String uri = this.getStringValue("FilePath");
            ExternalLinkImpl link = new ExternalLinkImpl(new RegisteredLinkTypeImpl(this.getStringValue("OriginalName")), uri, this.getStringValue("Comment"), this.getIntValue("ExtID"), false, false);
            this.getWorkItem().getLinksInternal().add(link);
        } else {
            throw new RuntimeException(MessageFormat.format("unexpected row type in Files rowset [{0}]", Integer.toString(fieldId)));
        }
    }

    private void incrementCount(Map<Integer, Map<Date, Integer>> data, int fieldId, Date date) {
        Integer currentCount;
        Integer key = new Integer(fieldId);
        Map<Date, Integer> countMap = data.get(key);
        if (countMap == null) {
            countMap = new HashMap<Date, Integer>();
            data.put(key, countMap);
        }
        if ((currentCount = countMap.get(date)) == null) {
            countMap.put(date, new Integer(1));
        } else {
            countMap.put(date, new Integer(currentCount + 1));
        }
    }

    @Override
    public void handleEndParsing() {
        int currentAttachedFileCount = 0;
        int currentExternalLinkCount = 0;
        int currentHyperlinkCount = 0;
        for (int i = 0; i < this.getWorkItem().getRevisionsInternal().size(); ++i) {
            RevisionImpl revision = this.getWorkItem().getRevisionsInternal().getRevisionInternal(i);
            Date revisionDate = revision.getRevisionDate();
            currentAttachedFileCount = this.addCountToRevision(revision, revisionDate, currentAttachedFileCount, 50, -31);
            currentExternalLinkCount = this.addCountToRevision(revision, revisionDate, currentExternalLinkCount, 58, -57);
            currentHyperlinkCount = this.addCountToRevision(revision, revisionDate, currentHyperlinkCount, 51, -32);
        }
    }

    private int addCountToRevision(RevisionImpl revision, Date revisionDate, int currentCount, int trackerFieldId, int countFieldId) {
        Integer removeCounts;
        Map<Date, Integer> dateToRemoves;
        Integer addCounts;
        Integer key = new Integer(trackerFieldId);
        revision.getFieldInternal(countFieldId).setOriginalValue(new Integer(currentCount));
        Map<Date, Integer> dateToAdds = this.adds.get(key);
        if (dateToAdds != null && (addCounts = dateToAdds.get(revisionDate)) != null) {
            currentCount += addCounts.intValue();
        }
        if ((dateToRemoves = this.removes.get(key)) != null && (removeCounts = dateToRemoves.get(revisionDate)) != null) {
            currentCount -= removeCounts.intValue();
        }
        revision.getFieldInternal(countFieldId).setNewValue(new Integer(currentCount));
        return currentCount;
    }
}

