/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rules.cache;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.rules.Rule;
import com.microsoft.tfs.core.clients.workitem.internal.rules.ValueProvidingRuleComparator;
import com.microsoft.tfs.core.clients.workitem.internal.rules.cache.IRuleCache;
import com.microsoft.tfs.core.clients.workitem.internal.rules.cache.RulePersonScopeCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RuleCache
implements IRuleCache {
    private final IMetadata metadata;
    private final Map<Integer, RuleCacheNode> idToCacheNode = new HashMap<Integer, RuleCacheNode>();
    private final RulePersonScopeCache rulePersonScopeCache;

    public RuleCache(WITContext witContext) {
        this.metadata = witContext.getMetadata();
        this.rulePersonScopeCache = new RulePersonScopeCache(witContext);
    }

    @Override
    public RuleCacheResults getRules(int areaId) {
        return this.getCacheNode(areaId).getRules();
    }

    @Override
    public RuleCacheResults getRules(int areaId, int changedFieldId) {
        return this.getCacheNode(areaId).getRulesForChangedFieldID(changedFieldId);
    }

    public synchronized void clearCache() {
        this.idToCacheNode.clear();
        this.rulePersonScopeCache.clear();
    }

    private synchronized RuleCacheNode getCacheNode(int areaId) {
        Integer key = new Integer(areaId);
        RuleCacheNode node = this.idToCacheNode.get(key);
        if (node == null) {
            int parentId = this.metadata.getHierarchyTable().getParentID(areaId);
            node = parentId == areaId ? new RuleCacheNode(areaId, null, this.metadata, this.rulePersonScopeCache) : new RuleCacheNode(areaId, this.getCacheNode(parentId), this.metadata, this.rulePersonScopeCache);
            this.idToCacheNode.put(key, node);
        }
        return node;
    }

    private static class RuleCacheNode {
        private final RuleCacheNode parent;
        private final int areaId;
        private final IMetadata metadata;
        private final RulePersonScopeCache rulePersonScopeCache;
        private RuleCacheResults allNodeRules;
        private Map<Integer, RuleCacheResults> changedFieldIdToRuleCacheResults;
        private boolean calculatedRules = false;
        private boolean delegateToParent = false;

        public RuleCacheNode(int areaId, RuleCacheNode parent, IMetadata metadata, RulePersonScopeCache rulePersonScopeCache) {
            this.areaId = areaId;
            this.parent = parent;
            this.metadata = metadata;
            this.rulePersonScopeCache = rulePersonScopeCache;
        }

        public synchronized RuleCacheResults getRules() {
            if (!this.calculatedRules) {
                this.calculateRules();
            }
            if (this.delegateToParent) {
                return this.parent.getRules();
            }
            return this.allNodeRules;
        }

        public synchronized RuleCacheResults getRulesForChangedFieldID(int changedFieldId) {
            if (!this.calculatedRules) {
                this.calculateRules();
            }
            if (this.delegateToParent) {
                return this.parent.getRulesForChangedFieldID(changedFieldId);
            }
            Integer key = new Integer(changedFieldId);
            if (!this.changedFieldIdToRuleCacheResults.containsKey(key)) {
                List<Rule> affectedRules = this.getAffectedRules(changedFieldId);
                Set<Integer> affectedFields = this.getAffectedFields(affectedRules);
                RuleCacheResults results = new RuleCacheResults();
                results.affectedFieldIds = affectedFields;
                results.defaultRules = new ArrayList<Rule>();
                results.nonDefaultRules = new ArrayList<Rule>();
                this.calculateRulesForChangedFieldID(this.allNodeRules.defaultRules, results.defaultRules, affectedFields, changedFieldId);
                this.calculateRulesForChangedFieldID(this.allNodeRules.nonDefaultRules, results.nonDefaultRules, affectedFields, changedFieldId);
                this.changedFieldIdToRuleCacheResults.put(key, results);
            }
            return this.changedFieldIdToRuleCacheResults.get(key);
        }

        private void calculateRulesForChangedFieldID(List<Rule> sourceRules, List<Rule> targetRules, Set<Integer> affectedFields, int changedFieldId) {
            for (Rule rule : sourceRules) {
                Integer thenFldId = new Integer(rule.getThenFldID());
                if (!affectedFields.contains(thenFldId) || rule.getThenFldID() == changedFieldId && rule.isFlagDefault()) continue;
                targetRules.add(rule);
            }
        }

        private Set<Integer> getAffectedFields(List<Rule> affectedRules) {
            HashSet<Integer> affectedFields = new HashSet<Integer>();
            for (Rule rule : affectedRules) {
                affectedFields.add(new Integer(rule.getThenFldID()));
            }
            return affectedFields;
        }

        private List<Rule> getAffectedRules(int changedFieldId) {
            ArrayList<Rule> affectedRules = new ArrayList<Rule>();
            for (Rule rule : this.allNodeRules.defaultRules) {
                if (!this.isAffectedByFieldChange(rule, changedFieldId)) continue;
                affectedRules.add(rule);
            }
            for (Rule rule : this.allNodeRules.nonDefaultRules) {
                if (!this.isAffectedByFieldChange(rule, changedFieldId)) continue;
                affectedRules.add(rule);
            }
            return affectedRules;
        }

        private boolean isAffectedByFieldChange(Rule rule, int changedFieldId) {
            return rule.getFld1ID() == changedFieldId || rule.getFld2ID() == changedFieldId || rule.getFld3ID() == changedFieldId || rule.getFld4ID() == changedFieldId || rule.getIfFldID() == changedFieldId || rule.getIf2FldID() == changedFieldId || rule.isFlagDenyWrite() && rule.getThenFldID() == changedFieldId;
        }

        private void calculateRules() {
            this.calculatedRules = true;
            Rule[] areaNodeRules = this.getRulesForAreaNode();
            if (areaNodeRules.length == 0 && this.parent != null) {
                this.delegateToParent = true;
            } else {
                this.changedFieldIdToRuleCacheResults = new HashMap<Integer, RuleCacheResults>();
                this.allNodeRules = new RuleCacheResults();
                this.allNodeRules.defaultRules = new ArrayList<Rule>();
                this.allNodeRules.nonDefaultRules = new ArrayList<Rule>();
                this.allNodeRules.affectedFieldIds = new HashSet<Integer>();
                for (int i = 0; i < areaNodeRules.length; ++i) {
                    if (areaNodeRules[i].isFlagDefault()) {
                        this.allNodeRules.defaultRules.add(areaNodeRules[i]);
                        this.allNodeRules.affectedFieldIds.add(new Integer(areaNodeRules[i].getThenFldID()));
                        continue;
                    }
                    this.allNodeRules.nonDefaultRules.add(areaNodeRules[i]);
                    this.allNodeRules.affectedFieldIds.add(new Integer(areaNodeRules[i].getThenFldID()));
                }
                if (this.parent != null) {
                    RuleCacheResults parentRules = this.parent.getRules();
                    for (Rule rule : parentRules.defaultRules) {
                        if (!rule.isFlagFlowdownTree()) continue;
                        this.allNodeRules.defaultRules.add(rule);
                        this.allNodeRules.affectedFieldIds.add(new Integer(rule.getThenFldID()));
                    }
                    for (Rule rule : parentRules.nonDefaultRules) {
                        if (!rule.isFlagFlowdownTree()) continue;
                        this.allNodeRules.nonDefaultRules.add(rule);
                        this.allNodeRules.affectedFieldIds.add(new Integer(rule.getThenFldID()));
                    }
                }
                Collections.sort(this.allNodeRules.defaultRules, new ValueProvidingRuleComparator());
                this.allNodeRules.affectedFieldIds.remove(new Integer(0));
            }
        }

        private Rule[] getRulesForAreaNode() {
            ArrayList<Rule> rules = new ArrayList<Rule>(Arrays.asList(this.metadata.getRulesTable().getRulesForAreaNode(this.areaId)));
            Iterator it = rules.iterator();
            while (it.hasNext()) {
                Rule rule = (Rule)it.next();
                if (this.rulePersonScopeCache.isRuleInScope(rule.getPersonID(), rule.isFlagInversePerson())) continue;
                it.remove();
            }
            return rules.toArray(new Rule[rules.size()]);
        }
    }

    public static class RuleCacheResults {
        public List<Rule> defaultRules;
        public List<Rule> nonDefaultRules;
        public Set<Integer> affectedFieldIds;
    }
}

