/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.update;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.update.BaseUpdatePackage;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.util.Date;
import org.w3c.dom.Element;

public class UpdateStoredQueryUpdatePackage
extends BaseUpdatePackage {
    private final StoredQueryImpl query;

    public UpdateStoredQueryUpdatePackage(StoredQueryImpl query, WITContext context) {
        super(context);
        this.query = query;
        Element queryElement = DOMUtils.appendChild(this.getRoot(), "UpdateQuery");
        queryElement.setAttribute("QueryID", query.getQueryGUID().getGUIDString(GUID.GUIDStringFormat.NONE));
        DOMUtils.appendChildWithText(queryElement, "Name", query.getName());
        DOMUtils.appendChildWithText(queryElement, "QueryText", query.getQueryText());
        DOMUtils.appendChildWithText(queryElement, "Description", query.getDescription());
    }

    @Override
    protected void handleUpdateResponse(DOMAnyContentType response) {
        Element responseElement = (Element)response.getElements()[0].getElementsByTagName("UpdateQuery").item(0);
        Date updateTime = this.parseDate(responseElement.getAttribute("UpdateTime"));
        this.query.updateAfterUpdate(updateTime);
    }
}

