/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.query;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemException;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinitionCollection;
import com.microsoft.tfs.core.clients.workitem.internal.query.qe.WIQLTranslator;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryDefinitionUtil;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Direction;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeSelect;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Parser;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxException;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.WIQLAdapter;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.query.QueryDocumentDirtyListener;
import com.microsoft.tfs.core.clients.workitem.query.QueryDocumentSaveListener;
import com.microsoft.tfs.core.clients.workitem.query.QueryScope;
import com.microsoft.tfs.core.clients.workitem.query.ResultOptionsColumnWidthPersistence;
import com.microsoft.tfs.core.clients.workitem.query.WIQDocument;
import com.microsoft.tfs.core.clients.workitem.query.qe.DisplayField;
import com.microsoft.tfs.core.clients.workitem.query.qe.DisplayFieldCollection;
import com.microsoft.tfs.core.clients.workitem.query.qe.ResultOptions;
import com.microsoft.tfs.core.clients.workitem.query.qe.SortField;
import com.microsoft.tfs.core.clients.workitem.query.qe.SortFieldCollection;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.LinkQueryMode;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryDefinition;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryFolder;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryFolderUtil;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItem;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryType;
import com.microsoft.tfs.core.util.MementoRepository;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.listeners.ListenerList;
import com.microsoft.tfs.util.listeners.StandardListenerList;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;

public class QueryDocument {
    private static final String SELECT_FORMAT_STRING = "{0} FROM {1} {2} {3} {4}";
    private static final String WHERE_CLAUSE_FORMAT = "{0} {1}";
    private static final String WHERE_STRING = "WHERE";
    private static final String MODE_CLAUSE_FORMAT = "mode({0})";
    private boolean dirty = false;
    private final ListenerList dirtyListeners = new StandardListenerList();
    private final ListenerList saveListeners = new StandardListenerList();
    private GUID guid;
    private File file;
    private GUID parentGuid = GUID.EMPTY;
    private String description;
    private String filterExpression;
    private String name;
    private ResultOptions resultOptions;
    private final QueryScope scope;
    private GUID saveParent;
    private String saveDescription;
    private String saveFilterExpression;
    private String saveName;
    private ResultOptions saveResultOptions;
    private QueryScope saveScope;
    private LinkQueryMode queryMode;
    private LinkQueryMode saveQueryMode;
    private QueryType queryType;
    private QueryType saveQueryType;
    private final WorkItemClient workItemClient;
    private String projectName;
    private String teamName;

    public static ResultOptions getDefaultResultOptions(FieldDefinitionCollection fieldDefinitions, QueryDocument queryDocument) {
        ResultOptions options = new ResultOptions(queryDocument);
        QueryDocument.getDefaultDisplayFields(options.getDisplayFields(), fieldDefinitions);
        QueryDocument.getDefaultSortFields(options.getSortFields(), fieldDefinitions);
        return options;
    }

    private static void getDefaultDisplayFields(DisplayFieldCollection dfc, FieldDefinitionCollection fieldDefinitions) {
        dfc.clear();
        dfc.add(new DisplayField(DisplayField.getLocalizedFieldName("System.Id", fieldDefinitions), ResultOptions.getDefaultColumnWidth("System.Id", fieldDefinitions)));
        dfc.add(new DisplayField(DisplayField.getLocalizedFieldName("System.Title", fieldDefinitions), ResultOptions.getDefaultColumnWidth("System.Title", fieldDefinitions)));
    }

    private static void getDefaultSortFields(SortFieldCollection sfc, FieldDefinitionCollection fieldDefinitions) {
        sfc.clear();
        sfc.add(new SortField(DisplayField.getLocalizedFieldName("System.Id", fieldDefinitions), true));
    }

    public QueryDocument(WorkItemClient workItemClient) {
        Check.notNull(workItemClient, "workItemClient");
        this.queryType = QueryType.LIST;
        this.saveQueryType = QueryType.LIST;
        this.queryMode = LinkQueryMode.WORK_ITEMS;
        this.saveQueryMode = LinkQueryMode.WORK_ITEMS;
        this.workItemClient = workItemClient;
        this.resultOptions = QueryDocument.getDefaultResultOptions(null, this);
        this.scope = QueryScope.PRIVATE;
        this.dirty = false;
    }

    public void setFile(File file) {
        this.file = file;
        this.guid = null;
    }

    public void setGUID(GUID guid) {
        this.guid = guid;
        this.file = null;
    }

    public void restoreGUIDAndFile(GUID guid, File file) {
        this.guid = guid;
        this.file = file;
    }

    public void setParentGUID(GUID parentGuid) {
        this.parentGuid = parentGuid;
        this.dirty = true;
        this.notifyDirtyListeners();
    }

    public void load() {
        try {
            if ((this.file != null || this.guid != null) && this.getResultOptions() != null) {
                this.getResultOptions().getDisplayFields().clear();
                this.getResultOptions().getSortFields().clear();
            }
            if (this.file != null) {
                this.loadFromFile();
            } else if (this.guid != null) {
                this.loadFromServer();
            }
            this.clearDirty();
            this.saveState();
        }
        catch (SyntaxException se) {
            throw new WorkItemException(Messages.getString("QueryDocument.ClientDoesNotSupportQueryType"), 265000);
        }
    }

    private void loadFromFile() {
        URI documentServer;
        WIQDocument wiqDocument = WIQDocument.load(this.file);
        if (wiqDocument.getTeamFoundationServer() == null || wiqDocument.getTeamProject() == null) {
            throw new RuntimeException(Messages.getString("QueryDocument.FileDoesNotSpecifyServerOrProject"));
        }
        URI currentServer = URIUtils.toLowerCase(this.workItemClient.getConnection().getBaseURI());
        if (!currentServer.equals(documentServer = URIUtils.toLowerCase(URIUtils.ensurePathHasTrailingSlash(URIUtils.newURI(wiqDocument.getTeamFoundationServer()))))) {
            throw new RuntimeException(Messages.getString("QueryDocument.ServerDoesNotMatchCurrentTfs"));
        }
        String documentProject = wiqDocument.getTeamProject();
        Project project = this.workItemClient.getProjects().get(documentProject);
        if (project == null) {
            String messageFormat = Messages.getString("QueryDocument.ProjectDoesNotExistFormat");
            String message = MessageFormat.format(messageFormat, documentProject);
            throw new RuntimeException(message);
        }
        this.setProjectName(project.getName());
        String documentTeamName = wiqDocument.getTeamName();
        this.setTeamName(documentTeamName);
        this.setDocumentFieldsFromWIQL(wiqDocument.getWIQL());
        String nameWithoutExtension = this.file.getName();
        nameWithoutExtension = nameWithoutExtension.substring(0, nameWithoutExtension.lastIndexOf("."));
        this.setName(nameWithoutExtension);
    }

    private void loadFromServer() {
        QueryDefinition definition = (QueryDefinition)this.workItemClient.getProjects().get(this.getProjectName()).getQueryHierarchy().find(this.guid);
        if (definition.getQueryText() == null || definition.getQueryText().equals("")) {
            throw new WorkItemException(Messages.getString("QueryDocument.QueryDefinitionDoesNoHaveAssocQuery"));
        }
        this.setDocumentFieldsFromWIQL(definition.getQueryText());
        this.setName(definition.getName());
        this.setParentGUID(definition.getParent().getID());
    }

    public void save() {
        if (this.file != null) {
            this.saveToFile();
        } else {
            this.saveToServer();
        }
        ResultOptionsColumnWidthPersistence.persist(new MementoRepository(this.workItemClient.getConnection().getPersistenceStoreProvider().getCachePersistenceStore()), this);
        this.dirty = false;
        this.notifyDirtyListeners();
        this.notifySaveListeners();
        this.saveState();
    }

    private void saveToFile() {
        String queryText = this.getQueryText();
        String teamName = StringUtil.isNullOrEmpty(queryText) || !queryText.contains("@currentIteration") ? null : this.getTeamName();
        WIQDocument wiqDocument = new WIQDocument(queryText, this.getWorkItemClient().getConnection().getBaseURI().toString(), this.getProjectName(), teamName);
        wiqDocument.save(this.file);
    }

    private void saveToServer() {
        QueryDefinition queryDefinition;
        if (this.guid == null) {
            QueryItem queryItem = this.getExistingQueryByName(this.getName());
            if (queryItem == null || !(queryItem instanceof QueryDefinition)) {
                QueryFolder parent = this.getFolder(this.getParentGUID(), this.getProjectName());
                queryDefinition = parent.newDefinition(this.name, this.getQueryText());
            } else {
                queryDefinition = (QueryDefinition)queryItem;
            }
        } else {
            queryDefinition = this.getQueryDefinition();
            if (queryDefinition == null) {
                throw new WorkItemException(MessageFormat.format(Messages.getString("QueryDocument.QueryCouldNotSaveToSpecifiedLocationFormat"), this.name));
            }
        }
        queryDefinition.setName(this.name);
        queryDefinition.setQueryText(this.getQueryText());
        try {
            this.workItemClient.getProjects().get(this.getProjectName()).getQueryHierarchy().save();
        }
        catch (RuntimeException e) {
            this.workItemClient.getProjects().get(this.getProjectName()).getQueryHierarchy().reset();
            throw e;
        }
    }

    private QueryFolder getFolder(GUID id, String project) {
        QueryItem possibleFolder = this.workItemClient.getProjects().get(project).getQueryHierarchy().find(id);
        if (possibleFolder instanceof QueryFolder) {
            return (QueryFolder)possibleFolder;
        }
        return null;
    }

    public QueryItem getExistingQueryByName(String name) {
        QueryItem parent = this.workItemClient.getProjects().get(this.projectName).getQueryHierarchy().find(this.parentGuid);
        if (parent instanceof QueryFolder && ((QueryFolder)parent).containsName(name)) {
            return ((QueryFolder)parent).getItemByName(name);
        }
        return null;
    }

    private QueryDefinition getQueryDefinition() {
        QueryItem queryItem;
        if (this.guid != null && (queryItem = this.workItemClient.getProjects().get(this.getProjectName()).getQueryHierarchy().find(this.guid)) instanceof QueryDefinition) {
            return (QueryDefinition)queryItem;
        }
        return null;
    }

    public QueryScope getQueryScope() {
        QueryItem queryDefinition = this.getQueryDefinition();
        if (queryDefinition == null) {
            queryDefinition = this.getParentFolder();
        }
        if (queryDefinition != null && !queryDefinition.isPersonal()) {
            return QueryScope.PUBLIC;
        }
        return QueryScope.PRIVATE;
    }

    private QueryFolder getParentFolder() {
        return this.getFolder(this.getParentGUID(), this.getProjectName());
    }

    public void setQueryScope(QueryScope scope) {
        if (!this.getQueryScope().equals(scope)) {
            QueryFolder defaultParent = WorkItemClient.getDefaultParent(this.workItemClient.getProjects().get(this.getProjectName()), scope == QueryScope.PUBLIC);
            this.parentGuid = defaultParent.getID();
            this.dirty = true;
            this.notifyDirtyListeners();
        }
    }

    public ResultOptions getResultOptions() {
        return this.resultOptions;
    }

    public void setResultOptions(ResultOptions resultOptions) {
        Check.notNull(resultOptions, "resultOptions");
        int changeType = 7;
        if (this.resultOptions != null) {
            changeType = ResultOptions.determineChange(this.resultOptions, resultOptions);
        }
        this.resultOptions = resultOptions;
        if (changeType != 1 && changeType != 0) {
            this.dirty = true;
            this.notifyDirtyListeners();
        }
    }

    public String getFilterExpression() {
        if (this.filterExpression == null) {
            return "";
        }
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        boolean equal;
        boolean bl = this.filterExpression == null ? filterExpression == null : (equal = this.filterExpression.equals(filterExpression));
        if (!equal) {
            this.filterExpression = filterExpression;
            this.dirty = true;
            this.notifyDirtyListeners();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.dirty = true;
        this.notifyDirtyListeners();
    }

    public void updateName(String name) {
        this.name = name;
    }

    public String getHierarchicalPath() {
        QueryFolder parentFolder = this.getParentFolder();
        StringBuffer sb = new StringBuffer();
        sb.append(QueryFolderUtil.getHierarchicalPath(parentFolder));
        if (sb.length() > 0) {
            sb.append("\\");
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.dirty = true;
        this.notifyDirtyListeners();
    }

    public String getQueryText() {
        return this.generateWIQL(this.getResultOptions());
    }

    public void setQueryText(String queryText) {
        this.setDocumentFieldsFromWIQL(queryText);
        this.dirty = true;
        this.notifyDirtyListeners();
    }

    public LinkQueryMode getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(LinkQueryMode queryMode) {
        this.queryMode = queryMode;
        this.dirty = true;
        this.notifyDirtyListeners();
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
        this.resultOptions.onQueryTypeChanged(this.workItemClient.getFieldDefinitions());
        this.dirty = true;
        this.notifyDirtyListeners();
    }

    public void reset() {
        this.restoreState();
    }

    public GUID getGUID() {
        return this.guid;
    }

    public GUID getParentGUID() {
        return this.parentGuid;
    }

    public File getFile() {
        return this.file;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public WorkItemClient getWorkItemClient() {
        return this.workItemClient;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
        this.notifyDirtyListeners();
    }

    public void addDirtyListener(QueryDocumentDirtyListener listener) {
        this.dirtyListeners.addListener(listener);
    }

    public void removeDirtyListener(QueryDocumentDirtyListener listener) {
        this.dirtyListeners.removeListener(listener);
    }

    private void notifyDirtyListeners() {
        QueryDocumentDirtyListener[] listeners = (QueryDocumentDirtyListener[])this.dirtyListeners.getListeners(new QueryDocumentDirtyListener[this.dirtyListeners.size()]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].dirtyStateChanged(this);
        }
    }

    public void addSaveListener(QueryDocumentSaveListener listener) {
        this.saveListeners.addListener(listener);
    }

    public void removeSaveListener(QueryDocumentSaveListener listener) {
        this.saveListeners.removeListener(listener);
    }

    private void notifySaveListeners() {
        QueryDocumentSaveListener[] listeners = (QueryDocumentSaveListener[])this.saveListeners.getListeners(new QueryDocumentSaveListener[this.saveListeners.size()]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].onQueryDocumentSaved(this);
        }
    }

    private String generateWIQL(ResultOptions resultOptions) {
        return this.generateWIQL(resultOptions, this.getFilterExpression());
    }

    private String generateWIQL(ResultOptions resultOptions, String whereClause) {
        if (whereClause.trim().length() > 0) {
            whereClause = MessageFormat.format(WHERE_CLAUSE_FORMAT, WHERE_STRING, whereClause);
        }
        String tableName = LinkQueryMode.WORK_ITEMS.equals(this.queryMode) ? "WorkItems" : "WorkItemLinks";
        String mode = "";
        if (LinkQueryMode.LINKS_MUST_CONTAIN.equals(this.queryMode)) {
            mode = "MustContain";
        } else if (LinkQueryMode.LINKS_MUST_CONTAIN.equals(this.queryMode)) {
            mode = "MustContain";
        } else if (LinkQueryMode.LINKS_MAY_CONTAIN.equals(this.queryMode)) {
            mode = "MayContain";
        } else if (LinkQueryMode.LINKS_DOES_NOT_CONTAIN.equals(this.queryMode)) {
            mode = "DoesNotContain";
        } else if (LinkQueryMode.LINKS_RECURSIVE.equals(this.queryMode)) {
            mode = "Recursive";
        }
        String modeClause = mode.length() > 0 ? MessageFormat.format(MODE_CLAUSE_FORMAT, mode) : "";
        return MessageFormat.format(SELECT_FORMAT_STRING, resultOptions.getSelectClause(this.workItemClient.getFieldDefinitions()), tableName, whereClause, resultOptions.getOrderByClause(this.workItemClient.getFieldDefinitions()), modeClause);
    }

    private void saveState() {
        this.saveParent = this.parentGuid;
        this.saveScope = this.scope;
        this.saveResultOptions = new ResultOptions(this.resultOptions, true, this);
        this.saveQueryType = this.getQueryType();
        this.saveQueryMode = this.getQueryMode();
        this.saveFilterExpression = this.filterExpression;
        this.saveName = this.name;
        this.saveDescription = this.description;
    }

    private void restoreState() {
        this.setParentGUID(this.saveParent);
        this.setQueryScope(this.saveScope);
        this.setResultOptions(this.saveResultOptions);
        this.setFilterExpression(this.saveFilterExpression);
        this.setName(this.saveName);
        this.setDescription(this.saveDescription);
        this.setQueryType(this.saveQueryType);
        this.setQueryMode(this.saveQueryMode);
        this.dirty = false;
        this.notifyDirtyListeners();
    }

    public boolean isLinkQuery() {
        return !LinkQueryMode.WORK_ITEMS.equals(this.queryMode);
    }

    public boolean isTreeQuery() {
        return LinkQueryMode.LINKS_RECURSIVE.equals(this.queryMode);
    }

    private void setDocumentFieldsFromWIQL(String wiql) {
        if (wiql != null && wiql.length() > 0) {
            String name;
            NodeFieldName node;
            int i;
            NodeSelect select = Parser.parseSyntax(wiql);
            this.getResultOptions().getDisplayFields().clear();
            this.getResultOptions().getSortFields().clear();
            if (select.getWhere() != null) {
                this.setFilterExpression(WIQLTranslator.wiqlNodeAsString(select.getWhere(), wiql));
            } else {
                this.setFilterExpression("");
            }
            this.queryMode = WIQLAdapter.getQueryMode(select);
            this.queryType = QueryDefinitionUtil.getQueryType(this.queryMode);
            if (select.getFields() != null) {
                for (i = 0; i < select.getFields().getCount(); ++i) {
                    node = select.getFields().getNodeFieldNameItem(i);
                    name = DisplayField.getLocalizedFieldName(node.getValue(), this.workItemClient.getFieldDefinitions());
                    this.getResultOptions().getDisplayFields().add(new DisplayField(name, ResultOptions.getDefaultColumnWidth(name, this.workItemClient.getFieldDefinitions())));
                }
            }
            if (this.guid != null || this.file != null) {
                ResultOptionsColumnWidthPersistence.restore(new MementoRepository(this.workItemClient.getConnection().getPersistenceStoreProvider().getCachePersistenceStore()), this);
            }
            if (select.getOrderBy() != null) {
                for (i = 0; i < select.getOrderBy().getCount(); ++i) {
                    node = select.getOrderBy().getNodeFieldNameItem(i);
                    name = DisplayField.getLocalizedFieldName(node.getValue(), this.workItemClient.getFieldDefinitions());
                    this.getResultOptions().getSortFields().add(new SortField(name, node.getDirection() != Direction.DESCENDING));
                }
            }
        } else {
            this.getResultOptions().getDisplayFields().clear();
            this.getResultOptions().getSortFields().clear();
            this.setFilterExpression("");
        }
    }
}

