/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config;

import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.util.StringUtil;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EnvironmentVariables {
    private static final Log logger = LogFactory.getLog(EnvironmentVariables.class);
    public static final String ACCEPT_UNTRUSTED_CERTIFICATES = "TF_ACCEPT_UNTRUSTED_CERTIFICATES";
    public static final String SSL_PROTOCOL_NAME = "TF_SSL_PROTOCOL_NAME";
    public static final String USE_LEGACY_MSA = "TF_USE_LEGACY_MSA";
    public static final String USE_OAUTH_LIBRARY = "TF_USE_OAUTH_LIBRARY";
    public static final String UPLOAD_CHUNK_SIZE = "TF_UPLOAD_CHUNK_SIZE";
    public static final String UPLOAD_BUFFER_SIZE = "TF_UPLOAD_BUFFER_SIZE";
    public static final String MAX_FILE_RETRY_ATTEMPTS = "TF_MAX_FILE_RETRY_ATTEMPTS";
    public static final String MAX_CHUNK_RETRY_ATTEMPTS = "TF_MAX_CHUNK_RETRY_ATTEMPTS";
    public static final String DISABLE_DETECT_EXECUTABLE_PROP = "TF_DISABLE_DETECT_EXECUTABLE_PROP";
    public static final String DISABLE_APPLY_EXECUTABLE_PROP = "TF_DISABLE_APPLY_EXECUTABLE_PROP";
    public static final String GLOBAL_TPATTRIBUTES = "TF_GLOBAL_TPATTRIBUTES";
    public static final String DISABLE_SYMBOLIC_LINK_PROP = "TF_DISABLE_SYMBOLIC_LINK_PROP";
    public static final String TF_PROXY = "TFSPROXY";
    public static final String WORKSTATION_CACHE_DIRECTORY = "TFSVC_CACHE_DIR";
    public static final String WORKSTATION_CONFIGURATION_DIRECTORY = "TFSVC_CONFIG_DIR";
    public static final String OFFLINE_METADATA_ROOT_DIRECTORY = "TFS_OFFLINE_METADATA_ROOT";
    public static final String TEE_PROFILE_DIRECTORY = "TEE_PROFILE_DIRECTORY";
    public static final String DD_SUITES_PROJECT_RENAME_UNPATCHED_CLIENT = "TF_DD_SUITES_PROJECT_RENAME_UNPATCHED_CLIENT";
    public static final String HOME = "HOME";
    public static final String USER_PROFILE = "USERPROFILE";

    public static int getInt(String variableName, int defaultValue) {
        String value = EnvironmentVariables.getString(variableName);
        if (StringUtil.isNullOrEmpty(value)) {
            return defaultValue;
        }
        try {
            int number = StringUtil.toInt(value);
            return number;
        }
        catch (NumberFormatException e) {
            String message = MessageFormat.format("Incorrect value of the environment variable {0} = {1}", variableName, value);
            logger.error((Object)message, (Throwable)e);
            return defaultValue;
        }
    }

    public static boolean getBoolean(String variableName, boolean defaultValue) {
        String value = EnvironmentVariables.getString(variableName);
        if (StringUtil.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return !value.equalsIgnoreCase("FALSE") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("N");
    }

    public static String getString(String variableName) {
        return PlatformMiscUtils.getInstance().getEnvironmentVariable(variableName);
    }

    public static String getString(String variableName, String defaultValue) {
        String value = EnvironmentVariables.getString(variableName);
        if (StringUtil.isNullOrEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public static boolean isDefined(String variableName) {
        return !StringUtil.isNullOrEmpty(EnvironmentVariables.getString(variableName));
    }
}

