/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.jni.RegistryException;
import com.microsoft.tfs.jni.RegistryKey;
import com.microsoft.tfs.jni.RootKey;
import com.microsoft.tfs.util.Platform;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RegistryUtils {
    private static final Log log = LogFactory.getLog(RegistryUtils.class);
    public static final String VISUAL_STUDIO_KEY_ROOT_PATH = "Software\\Microsoft\\VisualStudio\\12.0";

    public static RegistryKey openOrCreateRootUserRegistryKey() {
        if (!Platform.isCurrentPlatform(Platform.WINDOWS)) {
            throw new RuntimeException(Messages.getString("RegistryUtils.RegistryFeaturesNotAvailable"));
        }
        RegistryKey key = new RegistryKey(RootKey.HKEY_CURRENT_USER, VISUAL_STUDIO_KEY_ROOT_PATH);
        if (!key.exists()) {
            try {
                key.create();
            }
            catch (RegistryException e) {
                log.error((Object)MessageFormat.format(Messages.getString("RegistryUtils.CouldNotCreateRegistryKeyFormat"), key), (Throwable)e);
                key = null;
            }
        }
        return key;
    }
}

