/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.config.httpclient.internal;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultX509TrustManager
implements X509TrustManager {
    private final X509TrustManager standardTrustManager;
    private static final Log log = LogFactory.getLog(DefaultX509TrustManager.class);
    private static String[] certificateResources = new String[]{"certs/MicrosoftInternetAuthority.x509"};
    private static final X509Certificate[] certificateAdditions;

    public DefaultX509TrustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore);
        TrustManager[] trustManagers = factory.getTrustManagers();
        if (trustManagers.length == 0) {
            throw new NoSuchAlgorithmException("No trust manager found");
        }
        if (!(trustManagers[0] instanceof X509TrustManager)) {
            throw new NoSuchAlgorithmException("No X509 trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustManagers[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        X509Certificate terminalCertificate;
        if (certificates != null && certificates.length > 0 && !(terminalCertificate = certificates[certificates.length - 1]).getIssuerX500Principal().equals(terminalCertificate.getSubjectX500Principal())) {
            for (X509Certificate certificateAddition : certificateAdditions) {
                if (!terminalCertificate.getIssuerX500Principal().equals(certificateAddition.getSubjectX500Principal())) continue;
                log.info((Object)MessageFormat.format("Including certificate for {0}", certificateAddition.getSubjectX500Principal()));
                X509Certificate[] newCertificates = new X509Certificate[certificates.length + 1];
                for (int i = 0; i < certificates.length; ++i) {
                    newCertificates[i] = certificates[i];
                }
                newCertificates[newCertificates.length - 1] = certificateAddition;
                certificates = newCertificates;
                break;
            }
        }
        this.standardTrustManager.checkServerTrusted(certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    private static X509Certificate loadResourceAsX509Certificate(String resource) {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (Exception e) {
            log.warn((Object)"Could not load X509 certificate factory", (Throwable)e);
            return null;
        }
        InputStream certificateStream = DefaultX509TrustManager.class.getResourceAsStream(resource);
        if (certificateStream == null) {
            log.warn((Object)MessageFormat.format("Could not load X509 certificate from {0}", resource));
            return null;
        }
        try {
            Certificate certificate = certificateFactory.generateCertificate(certificateStream);
            if (certificate != null && certificate instanceof X509Certificate) {
                return (X509Certificate)certificate;
            }
            log.warn((Object)MessageFormat.format("Could not generate X509 certificate from {0}", resource));
        }
        catch (CertificateException e) {
            log.warn((Object)MessageFormat.format("Could not generate X509 certificate from {0}", resource), (Throwable)e);
        }
        return null;
    }

    static {
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        if (certificateResources != null) {
            for (String resource : certificateResources) {
                X509Certificate certificate = DefaultX509TrustManager.loadResourceAsX509Certificate(resource);
                if (certificate == null) continue;
                certificateList.add(certificate);
            }
        }
        certificateAdditions = certificateList.toArray(new X509Certificate[certificateList.size()]);
    }
}

