/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.exceptions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.httpclient.CookieCredentials;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.JwtCredentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.util.TFSUser;
import com.microsoft.tfs.core.util.UserNameUtil;
import com.microsoft.tfs.core.ws.runtime.exceptions.UnauthorizedException;
import com.microsoft.tfs.util.Check;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TFSUnauthorizedException
extends TECoreException {
    private static final Log log = LogFactory.getLog(TFSUnauthorizedException.class);

    public TFSUnauthorizedException(UnauthorizedException e) {
        super(TFSUnauthorizedException.buildMessage(e), e);
    }

    private static String buildMessage(UnauthorizedException e) {
        Check.notNull(e, "e");
        String displayURIString = TFSUnauthorizedException.getDisplayURIString(e.getURI());
        Credentials credentials = e.getCredentials();
        if (credentials instanceof DefaultNTCredentials) {
            String username = UserNameUtil.getCurrentUserName();
            String domain = UserNameUtil.getCurrentUserDomain();
            if (username != null) {
                return MessageFormat.format(Messages.getString("TFSUnauthorizedException.AccessDeniedAuthenticatingAsFormat"), displayURIString, new TFSUser(username, domain).toString());
            }
            return MessageFormat.format(Messages.getString("TFSUnauthorizedException.AccessDeniedAuthenticatingAsCurrentUserFormat"), displayURIString);
        }
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upCrendentials = (UsernamePasswordCredentials)credentials;
            return MessageFormat.format(Messages.getString("TFSUnauthorizedException.AccessDeniedAuthenticatingAsFormat"), displayURIString, upCrendentials.getUsername());
        }
        if (credentials instanceof CookieCredentials) {
            return MessageFormat.format(Messages.getString("TFSUnauthorizedException.AccessDeniedAuthenticatingUsingFederatedCredentialsFormat"), displayURIString);
        }
        if (credentials instanceof JwtCredentials) {
            return MessageFormat.format(Messages.getString("TFSUnauthorizedException.AccessDeniedAuthenticatingUsingServiceCredentialsFormat"), displayURIString);
        }
        if (credentials != null) {
            return MessageFormat.format(Messages.getString("TFSUnauthorizedException.AccessDeniedAuthenticatingUsingCredentialsFormat"), displayURIString, credentials);
        }
        return MessageFormat.format(Messages.getString("TFSUnauthorizedException.AccessDeniedAuthenticatingNoCredentialsFormat"), displayURIString);
    }

    private static String getDisplayURIString(String uriString) {
        String displayURIString;
        Check.notNull(uriString, "uriString");
        try {
            URI serverURI = new URI(uriString);
            displayURIString = new URI(serverURI.getScheme(), null, serverURI.getHost(), serverURI.getPort(), "/", null, null).toString();
        }
        catch (URISyntaxException uriSyntaxException) {
            log.error((Object)MessageFormat.format("Could not construct message URI for '{0}', returning raw URI string", uriString), (Throwable)uriSyntaxException);
            displayURIString = uriString;
        }
        return displayURIString;
    }
}

