/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.externaltools;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.externaltools.validators.ExternalToolException;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;

public abstract class WindowsStyleArgumentTokenizer {
    public static String getRawFirstToken(String arguments) {
        char c;
        if (arguments.length() == 0) {
            return arguments;
        }
        StringBuffer currentToken = new StringBuffer();
        int i = 0;
        while ((c = arguments.charAt(i)) == ' ' || c == '\t') {
            currentToken.append(c);
            ++i;
        }
        boolean inQuote = false;
        boolean lastQuote = false;
        while (i < arguments.length()) {
            char c2 = arguments.charAt(i);
            if (c2 == '\"') {
                if (lastQuote) {
                    lastQuote = false;
                } else if (inQuote) {
                    lastQuote = true;
                } else {
                    inQuote = true;
                }
                currentToken.append(c2);
            } else {
                if (lastQuote) {
                    inQuote = false;
                    lastQuote = false;
                }
                if (!(c2 != ' ' && c2 != '\t' || inQuote)) {
                    return currentToken.toString();
                }
                currentToken.append(c2);
            }
            ++i;
        }
        return currentToken.toString();
    }

    public static String[] tokenizeArguments(String arguments) throws ExternalToolException {
        Check.notNull(arguments, "arguments");
        String args = arguments.trim();
        ArrayList<StringBuffer> tokens = new ArrayList<StringBuffer>();
        StringBuffer currentToken = new StringBuffer();
        boolean inQuote = false;
        boolean lastQuote = false;
        for (int i = 0; i < args.length(); ++i) {
            char c = args.charAt(i);
            if (c == '\"') {
                if (lastQuote) {
                    currentToken.append('\"');
                    lastQuote = false;
                    continue;
                }
                if (inQuote) {
                    lastQuote = true;
                    continue;
                }
                inQuote = true;
                continue;
            }
            if (lastQuote) {
                inQuote = false;
                lastQuote = false;
            }
            if (!(c != ' ' && c != '\t' || inQuote)) {
                if (currentToken.length() <= 0) continue;
                tokens.add(currentToken);
                currentToken = new StringBuffer();
                continue;
            }
            currentToken.append(c);
        }
        if (lastQuote) {
            inQuote = false;
        }
        if (inQuote) {
            throw new ExternalToolException(Messages.getString("WindowsStyleArgumentTokenizer.UnterminatedDoubleQuoteInToolArguments"));
        }
        if (currentToken.length() > 0) {
            tokens.add(currentToken);
        }
        String[] converted = new String[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            converted[i] = tokens.get(i).toString();
        }
        return converted;
    }
}

