/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient;

import com.microsoft.tfs.core.httpclient.Cookie;
import com.microsoft.tfs.core.httpclient.Credentials;
import java.util.ArrayList;
import java.util.Arrays;

public class CookieCredentials
extends Credentials {
    private final Cookie[] cookies;

    public CookieCredentials(Cookie[] cookies) {
        if (cookies == null) {
            throw new IllegalArgumentException("Cookies may not be null");
        }
        this.cookies = cookies;
    }

    public CookieCredentials setDomain(String domain) {
        ArrayList<Cookie> newCookies = new ArrayList<Cookie>(this.cookies.length);
        for (Cookie cookie : this.cookies) {
            Cookie newCookie = new Cookie(domain, cookie.getName(), cookie.getValue(), "/", null, cookie.getSecure());
            newCookie.setPathAttributeSpecified(true);
            newCookies.add(newCookie);
        }
        return new CookieCredentials(newCookies.toArray(new Cookie[this.cookies.length]));
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public String toString() {
        return "(Cookie Credentials)";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.cookies);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CookieCredentials other = (CookieCredentials)obj;
        return Arrays.equals(this.cookies, other.cookies);
    }
}

