/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.auth;

import com.microsoft.tfs.core.httpclient.CookieCredentials;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.HttpState;
import com.microsoft.tfs.core.httpclient.auth.AuthScheme;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import com.microsoft.tfs.core.httpclient.auth.AuthenticationException;
import com.microsoft.tfs.core.httpclient.auth.MalformedChallengeException;

public class CookieAuthScheme
implements AuthScheme {
    @Override
    public boolean supportsCredentials(Credentials credentials) {
        return credentials instanceof CookieCredentials;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void processChallenge(String challenge) throws MalformedChallengeException {
        throw new MalformedChallengeException("Cookie authentication is not challenge/response");
    }

    @Override
    public String getSchemeName() {
        return "cookie";
    }

    @Override
    public String getParameter(String name) {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public void authenticateHost(AuthScope authscope, Credentials credentials, HttpState state, HttpMethod method) throws AuthenticationException {
        if (!(credentials instanceof CookieCredentials)) {
            throw new AuthenticationException("Invalid credentials for cookie authentication");
        }
        state.addCookies(((CookieCredentials)credentials).getCookies());
    }

    @Override
    public void authenticateProxy(AuthScope authScope, Credentials credentials, HttpState state, HttpMethod method) throws AuthenticationException {
        if (!(credentials instanceof CookieCredentials)) {
            throw new AuthenticationException("Invalid credentials for cookie authentication");
        }
        state.addCookies(((CookieCredentials)credentials).getCookies());
    }
}

