/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.cookie;

import com.microsoft.tfs.core.httpclient.cookie.CompatibilityCookieSpec;
import com.microsoft.tfs.core.httpclient.cookie.CookieSpec;
import com.microsoft.tfs.core.httpclient.cookie.CookieSpecBase;
import com.microsoft.tfs.core.httpclient.cookie.IgnoreCookiesSpec;
import com.microsoft.tfs.core.httpclient.cookie.NetscapeDraftSpec;
import com.microsoft.tfs.core.httpclient.cookie.RFC2109Spec;
import com.microsoft.tfs.core.httpclient.cookie.RFC2965Spec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CookiePolicy {
    private static Map<String, Class<? extends CookieSpec>> SPECS = Collections.synchronizedMap(new HashMap());
    public static final String BROWSER_COMPATIBILITY = "compatibility";
    public static final String NETSCAPE = "netscape";
    public static final String RFC_2109 = "rfc2109";
    public static final String RFC_2965 = "rfc2965";
    public static final String HTTPCLIENT_STANDARD = "httpclient-standard";
    public static final String IGNORE_COOKIES = "ignoreCookies";
    public static final String DEFAULT = "default";
    protected static final Log LOG;

    public static void registerCookieSpec(String id, Class<? extends CookieSpec> clazz) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Cookie spec class may not be null");
        }
        SPECS.put(id.toLowerCase(), clazz);
    }

    public static void unregisterCookieSpec(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        SPECS.remove(id.toLowerCase());
    }

    public static CookieSpec getCookieSpec(String id) throws IllegalStateException {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        Class<? extends CookieSpec> clazz = SPECS.get(id.toLowerCase());
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                LOG.error((Object)("Error initializing cookie spec: " + id), (Throwable)e);
                throw new IllegalStateException(id + " cookie spec implemented by " + clazz.getName() + " could not be initialized");
            }
        }
        throw new IllegalStateException("Unsupported cookie spec " + id);
    }

    public static String[] getRegisteredCookieSpecs() {
        return SPECS.keySet().toArray(new String[SPECS.size()]);
    }

    static {
        CookiePolicy.registerCookieSpec(DEFAULT, CompatibilityCookieSpec.class);
        CookiePolicy.registerCookieSpec(RFC_2109, RFC2109Spec.class);
        CookiePolicy.registerCookieSpec(RFC_2965, RFC2965Spec.class);
        CookiePolicy.registerCookieSpec(BROWSER_COMPATIBILITY, CompatibilityCookieSpec.class);
        CookiePolicy.registerCookieSpec(NETSCAPE, NetscapeDraftSpec.class);
        CookiePolicy.registerCookieSpec(IGNORE_COOKIES, IgnoreCookiesSpec.class);
        CookiePolicy.registerCookieSpec(HTTPCLIENT_STANDARD, CookieSpecBase.class);
        LOG = LogFactory.getLog(CookiePolicy.class);
    }
}

