/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.internal.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuration {
    private static final Log log = LogFactory.getLog(Configuration.class);
    private final Properties props = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration(Class cls, String resourceName) {
        InputStream input = null;
        input = cls.getResourceAsStream(resourceName);
        if (input != null) {
            this.props.load(input);
        } else {
            log.warn((Object)MessageFormat.format("configuration [{0}] from class [{1}] does not exist", resourceName, cls.getName()));
        }
        if (input == null) return;
        try {
            input.close();
            return;
        }
        catch (IOException e) {
            log.warn((Object)MessageFormat.format("error closing configuration [{0}] from class [{1}]", resourceName, cls.getName()), (Throwable)e);
        }
        return;
        catch (IOException ex) {
            try {
                log.warn((Object)MessageFormat.format("error loading configuration [{0}] from class [{1}]", resourceName, cls.getName()), (Throwable)ex);
                if (input == null) return;
            }
            catch (Throwable throwable) {
                if (input == null) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn((Object)MessageFormat.format("error closing configuration [{0}] from class [{1}]", resourceName, cls.getName()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                input.close();
                return;
            }
            catch (IOException e) {
                log.warn((Object)MessageFormat.format("error closing configuration [{0}] from class [{1}]", resourceName, cls.getName()), (Throwable)e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration(File inputFile) {
        FileInputStream input = null;
        input = new FileInputStream(inputFile);
        this.props.load(input);
        if (input == null) return;
        try {
            input.close();
            return;
        }
        catch (IOException e) {
            log.warn((Object)MessageFormat.format("error closing configuration [{0}]", inputFile.getAbsolutePath()), (Throwable)e);
        }
        return;
        catch (IOException ex) {
            try {
                log.warn((Object)MessageFormat.format("error loading configuration [{0}]", inputFile.getAbsolutePath()), (Throwable)ex);
                if (input == null) return;
            }
            catch (Throwable throwable) {
                if (input == null) throw throwable;
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn((Object)MessageFormat.format("error closing configuration [{0}]", inputFile.getAbsolutePath()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                input.close();
                return;
            }
            catch (IOException e) {
                log.warn((Object)MessageFormat.format("error closing configuration [{0}]", inputFile.getAbsolutePath()), (Throwable)e);
            }
            return;
        }
    }

    public String getConfiguration(String key, String defaultValue) {
        String sysProp = System.getProperty(key);
        if (sysProp != null) {
            return sysProp;
        }
        if (this.props.containsKey(key)) {
            return this.props.getProperty(key);
        }
        return defaultValue;
    }
}

