/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.internal.db;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.internal.db.ConnectionConfiguration;
import com.microsoft.tfs.core.internal.db.DBConnection;
import com.microsoft.tfs.core.internal.db.DBTask;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionPool {
    private static final Log log = LogFactory.getLog(ConnectionPool.class);
    private static final int POOL_SIZE = 10;
    private final List pooledConnections = new ArrayList();
    private final Map givenConnections = new HashMap();
    private boolean shutdown = false;
    private final ConnectionConfiguration connectionConfiguration;

    public ConnectionPool(ConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
    }

    public synchronized DBConnection getConnection() {
        if (this.shutdown) {
            throw new IllegalStateException(Messages.getString("ConnectionPool.ConnectionPoolHasBeenShutdown"));
        }
        if (this.pooledConnections.size() > 0) {
            DBConnection connection = (DBConnection)this.pooledConnections.remove(0);
            this.givenConnections.put(connection, MessageFormat.format("gave connection to [{0}] at [{1}]", Thread.currentThread().getName(), new Date()));
            return connection;
        }
        if (this.givenConnections.size() < 10) {
            DBConnection connection = this.connectionConfiguration.createNewConnection();
            this.givenConnections.put(connection, MessageFormat.format("gave connection to [{0}] at [{1}]", Thread.currentThread().getName(), new Date()));
            return connection;
        }
        throw new IllegalStateException(MessageFormat.format("no connections left in pool ({0})", this.givenConnections));
    }

    public synchronized void releaseConnection(DBConnection connection) {
        if (this.shutdown) {
            throw new IllegalStateException(Messages.getString("ConnectionPool.ConnectionPoolHasBeenShutdown"));
        }
        this.pooledConnections.add(connection);
        this.givenConnections.remove(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithPooledConnection(DBTask task) {
        DBConnection connection = this.getConnection();
        try {
            task.performTask(connection);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        if (this.givenConnections.size() > 0) {
            log.warn((Object)MessageFormat.format("shut down connection pool: some connections are still out ({0})", this.givenConnections));
        }
        for (DBConnection connection : this.pooledConnections) {
            connection.close();
        }
        if (this.connectionConfiguration.getDriverClass().equals("org.hsqldb.jdbcDriver")) {
            DBConnection connection = this.connectionConfiguration.createNewConnection();
            connection.createStatement("SHUTDOWN").executeUpdate();
        }
        this.connectionConfiguration.releaseLock();
        this.shutdown = true;
    }
}

