/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.internal.wrappers;

import com.microsoft.tfs.util.Check;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WrapperUtils {
    private static final Log log = LogFactory.getLog(WrapperUtils.class);
    public static final String UNWRAP_METHOD_NAME = "getWebServiceObject";

    public static Object wrap(Class wrapperType, Object[] webServiceObjects) {
        Check.notNull(wrapperType, "wrapperType");
        if (webServiceObjects == null) {
            return null;
        }
        Object ret = Array.newInstance(wrapperType, webServiceObjects.length);
        Class<?> webServiceObjectType = null;
        Constructor constructor = null;
        if (webServiceObjects.length > 0) {
            try {
                for (int i = 0; i < webServiceObjects.length; ++i) {
                    if (constructor == null && webServiceObjects[i] != null) {
                        webServiceObjectType = webServiceObjects[i].getClass();
                        constructor = wrapperType.getConstructor(webServiceObjectType);
                    }
                    Array.set(ret, i, webServiceObjects[i] != null ? constructor.newInstance(webServiceObjects[i]) : null);
                }
            }
            catch (NoSuchMethodException e) {
                String message = MessageFormat.format("Wrapper error: the desired wrapper class {0} does not have a visible constructor that accepts the web service type {1}", wrapperType, webServiceObjectType);
                log.error((Object)message, (Throwable)e);
                throw new RuntimeException(message);
            }
            catch (Exception e) {
                String message = MessageFormat.format("Error wrapping {0} in {1}", webServiceObjectType, wrapperType);
                log.error((Object)message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
        }
        return ret;
    }

    public static Object unwrap(Class webServiceObjectType, Object[] wrapperObjects) {
        Check.notNull(webServiceObjectType, "webServiceObjectType");
        if (wrapperObjects == null) {
            return null;
        }
        Object ret = Array.newInstance(webServiceObjectType, wrapperObjects.length);
        if (wrapperObjects.length > 0) {
            try {
                Method method = null;
                for (int i = 0; i < wrapperObjects.length; ++i) {
                    if (method == null && wrapperObjects[i] != null) {
                        method = wrapperObjects[i].getClass().getMethod(UNWRAP_METHOD_NAME, new Class[0]);
                    }
                    Array.set(ret, i, wrapperObjects[i] != null ? method.invoke(wrapperObjects[i], new Object[0]) : null);
                }
            }
            catch (NoSuchMethodException e) {
                String message = MessageFormat.format("Wrapper error: the given wrapper class {0} does not have a method named {1} that returns a {2}", wrapperObjects[0].getClass(), UNWRAP_METHOD_NAME, webServiceObjectType);
                log.error((Object)message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
            catch (Exception e) {
                String message = MessageFormat.format("Error unwrapping {0} from {1}", webServiceObjectType, wrapperObjects);
                log.error((Object)message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
        }
        return ret;
    }
}

