/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.client;

import com.microsoft.tfs.core.ws.runtime.client.SOAPMethodRequestWriter;
import com.microsoft.tfs.core.ws.runtime.client.SOAPRequestEntity;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SOAPRequestEntity12
extends SOAPRequestEntity {
    public SOAPRequestEntity12(String methodName, String defaultNamespace, SOAPMethodRequestWriter requestWriter) {
        super(methodName, defaultNamespace, requestWriter);
    }

    @Override
    public String getContentType() {
        return "application/soap+xml; charset=utf-8";
    }

    @Override
    public void writeRequest(OutputStream out) throws IOException {
        try {
            XMLStreamWriter writer = SOAPRequestEntity12.getXMLOutputFactory().createXMLStreamWriter(new BufferedOutputStream(out), "utf-8");
            writer.writeStartDocument();
            writer.writeStartElement("soap", "Envelope", "http://www.w3.org/2003/05/soap-envelope");
            writer.writeNamespace("soap", "http://www.w3.org/2003/05/soap-envelope");
            writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            writer.writeNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            if (this.getSoapHeaderProvider() != null) {
                writer.writeStartElement("soap", "Header", "http://www.w3.org/2003/05/soap-envelope");
                DOMAnyContentType.writeElement(writer, this.getSoapHeaderProvider().getSOAPHeader());
                writer.writeEndElement();
            }
            writer.writeStartElement("soap", "Body", "http://www.w3.org/2003/05/soap-envelope");
            writer.setDefaultNamespace(this.getDefaultNamespace());
            writer.writeDefaultNamespace(this.getDefaultNamespace());
            try {
                if (this.getRequestWriter() != null) {
                    this.getRequestWriter().writeSOAPRequest(writer, out);
                }
            }
            catch (XMLStreamException e) {
                throw new IOException(e.getMessage());
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }
}

