/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.client;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.Header;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.MultiThreadedHttpConnectionManager;
import com.microsoft.tfs.core.httpclient.URIException;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import com.microsoft.tfs.core.httpclient.methods.PostMethod;
import com.microsoft.tfs.core.httpclient.params.HttpClientParams;
import com.microsoft.tfs.core.ws.runtime.Messages;
import com.microsoft.tfs.core.ws.runtime.client.BufferedSOAPRequestEntity;
import com.microsoft.tfs.core.ws.runtime.client.SOAPHeaderProvider;
import com.microsoft.tfs.core.ws.runtime.client.SOAPMethodRequestWriter;
import com.microsoft.tfs.core.ws.runtime.client.SOAPMethodResponseReader;
import com.microsoft.tfs.core.ws.runtime.client.SOAPRequest;
import com.microsoft.tfs.core.ws.runtime.client.SOAPRequestEntity;
import com.microsoft.tfs.core.ws.runtime.client.TransportRequestHandler;
import com.microsoft.tfs.core.ws.runtime.exceptions.EndpointNotFoundException;
import com.microsoft.tfs.core.ws.runtime.exceptions.FederatedAuthException;
import com.microsoft.tfs.core.ws.runtime.exceptions.FederatedAuthFailedException;
import com.microsoft.tfs.core.ws.runtime.exceptions.InvalidServerResponseException;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyUnauthorizedException;
import com.microsoft.tfs.core.ws.runtime.exceptions.SOAPFault;
import com.microsoft.tfs.core.ws.runtime.exceptions.ServiceErrorException;
import com.microsoft.tfs.core.ws.runtime.exceptions.TransportException;
import com.microsoft.tfs.core.ws.runtime.exceptions.TransportRequestHandlerCanceledException;
import com.microsoft.tfs.core.ws.runtime.exceptions.UnauthorizedException;
import com.microsoft.tfs.core.ws.runtime.stax.StaxFactoryProvider;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleUtil;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import com.microsoft.tfs.util.xml.DOMSerializeUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SOAPService {
    private static final Log log = LogFactory.getLog(SOAPService.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    protected static final int RESPONSE_MAX_SIZE_FOR_DEBUG_LOGGING = 0x100000;
    protected static final boolean ALLOW_RESPONSE_COMPRESSION = !Boolean.getBoolean("teamexplorer.soap.disable-gzip");
    private final HttpClient client;
    private final URI endpoint;
    private final QName port;
    private volatile SOAPHeaderProvider soapHeaderProvider;
    private final List<TransportRequestHandler> transportRequestHandlers = new ArrayList<TransportRequestHandler>();
    private volatile String acceptLanguageHeaderValue;
    private volatile boolean promptForCredentials = true;
    private static final XMLInputFactory xmlInputFactory = StaxFactoryProvider.getXMLInputFactory(true);

    public SOAPService(HttpClient client, URI endpoint, QName port) {
        Check.notNull(client, "client");
        Check.notNull(endpoint, "endpoint");
        Check.notNull(port, "port");
        this.client = client;
        this.endpoint = endpoint;
        this.port = port;
    }

    public SOAPService(URI endpoint, QName port) {
        Check.notNull(endpoint, "endpoint");
        Check.notNull(port, "port");
        this.endpoint = endpoint;
        this.port = port;
        this.client = new HttpClient(new MultiThreadedHttpConnectionManager());
        HttpClientParams params = new HttpClientParams();
        params.setBooleanParameter("http.protocol.expect-continue", false);
        this.client.setParams(params);
    }

    public void setSOAPHeaderProvider(SOAPHeaderProvider soapHeaderProvider) {
        this.soapHeaderProvider = soapHeaderProvider;
    }

    public void setAcceptLanguage(Locale locale) {
        if (locale != null) {
            try {
                this.acceptLanguageHeaderValue = LocaleUtil.localeToRFC5646LanguageTag(locale);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"Couldn't turn Locale into Accept-Language header", (Throwable)e);
                this.acceptLanguageHeaderValue = null;
            }
        } else {
            this.acceptLanguageHeaderValue = null;
        }
        log.debug((Object)MessageFormat.format("Accept-Language header set to: {0}", this.acceptLanguageHeaderValue));
    }

    public boolean isPromptForCredentials() {
        return this.promptForCredentials;
    }

    public void setPromptForCredentials(boolean promptForCredentials) {
        this.promptForCredentials = promptForCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransportRequestHandler(TransportRequestHandler transportRequestHandler) {
        Check.notNull(transportRequestHandler, "transportRequestHandler");
        List<TransportRequestHandler> list = this.transportRequestHandlers;
        synchronized (list) {
            this.transportRequestHandlers.add(transportRequestHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransportRequestHandler(TransportRequestHandler transportRequestHandler) {
        Check.notNull(transportRequestHandler, "transportRequestHandler");
        List<TransportRequestHandler> list = this.transportRequestHandlers;
        synchronized (list) {
            this.transportRequestHandlers.remove(transportRequestHandler);
        }
    }

    protected void setRequestHeaders(HttpMethod method, String invokedMethod) {
        if (ALLOW_RESPONSE_COMPRESSION) {
            method.addRequestHeader("Accept-Encoding", "gzip");
        }
        if (this.acceptLanguageHeaderValue != null) {
            method.addRequestHeader("Accept-Language", this.acceptLanguageHeaderValue);
        }
    }

    protected abstract SOAPRequestEntity buildRequestEntity(String var1, SOAPMethodRequestWriter var2);

    protected abstract String getDefaultSOAPNamespace();

    protected SOAPRequest createSOAPRequest(String methodName, SOAPMethodRequestWriter requestWriter) {
        PostMethod method = new PostMethod(this.endpoint.toString());
        method.setContentChunked(false);
        this.setRequestHeaders(method, methodName);
        SOAPRequestEntity requestEntity = this.buildRequestEntity(methodName, requestWriter);
        requestEntity.setSOAPHeaderProvider(this.soapHeaderProvider);
        BufferedSOAPRequestEntity bufferedEntity = new BufferedSOAPRequestEntity(requestEntity);
        method.setRequestEntity(bufferedEntity);
        return new SOAPRequest(method, requestEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSOAPRequest(SOAPRequest request, String responseName, SOAPMethodResponseReader responseReader) throws SOAPFault, UnauthorizedException, ProxyUnauthorizedException, FederatedAuthException, InvalidServerResponseException, EndpointNotFoundException, TransportException, TransportRequestHandlerCanceledException {
        TransportRequestHandler requestHandler;
        ArrayList<TransportRequestHandler> requestHandlers = new ArrayList<TransportRequestHandler>();
        List<TransportRequestHandler> list = this.transportRequestHandlers;
        synchronized (list) {
            requestHandlers.addAll(this.transportRequestHandlers);
        }
        AtomicBoolean cancel = new AtomicBoolean(false);
        Iterator i$ = requestHandlers.iterator();
        while (i$.hasNext() && (requestHandler = (TransportRequestHandler)i$.next()).prepareRequest(this, request, cancel) != TransportRequestHandler.Status.COMPLETE) {
        }
        if (cancel.get()) {
            throw new TransportRequestHandlerCanceledException();
        }
        RuntimeException failure = null;
        block6: while (true) {
            try {
                this.executeSOAPRequestInternal(request, responseName, responseReader);
            }
            catch (RuntimeException e) {
                boolean exceptionHandled = false;
                cancel.set(false);
                for (TransportRequestHandler requestHandler2 : requestHandlers) {
                    if (requestHandler2.handleException(this, request, e, cancel) != TransportRequestHandler.Status.COMPLETE) continue;
                    request.getPostMethod().getHostAuthState().invalidate();
                    failure = null;
                    exceptionHandled = true;
                    continue block6;
                }
                if (exceptionHandled) continue;
                if (cancel.get()) {
                    failure = new TransportRequestHandlerCanceledException();
                    break;
                }
                failure = e;
            }
            break;
        }
        if (failure != null) {
            throw failure;
        }
        for (TransportRequestHandler requestHandler3 : requestHandlers) {
            requestHandler3.handleSuccess(this, request);
        }
    }

    /*
     * Exception decompiling
     */
    private void executeSOAPRequestInternal(SOAPRequest request, String responseName, SOAPMethodResponseReader responseReader) throws SOAPFault, UnauthorizedException, ProxyUnauthorizedException, InvalidServerResponseException, EndpointNotFoundException, TransportException, CanceledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 33[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected InputStream getResponseStream(PostMethod method) throws IOException {
        InputStream responseBody = method.getResponseBodyAsStream();
        Header encoding = method.getResponseHeader("Content-Encoding");
        if (encoding != null && encoding.getValue().equalsIgnoreCase("gzip")) {
            responseBody = new GZIPInputStream(method.getResponseBodyAsStream());
        }
        return responseBody;
    }

    protected String getFormattedBase64Encoding(byte[] responseBytes) {
        String unformatted;
        try {
            unformatted = new String(Base64.encodeBase64((byte[])responseBytes), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        StringBuffer sb = new StringBuffer();
        int ix = 0;
        while (ix < unformatted.length()) {
            int newIx = Math.min(ix + 80, unformatted.length());
            sb.append(unformatted.substring(ix, newIx));
            if (newIx < unformatted.length()) {
                sb.append(NEWLINE);
            }
            ix = newIx;
        }
        return sb.toString();
    }

    protected void finishSOAPRequest(SOAPRequest request) {
        request.getPostMethod().releaseConnection();
    }

    public void examineBodyForFault(PostMethod method) throws SOAPFault, InvalidServerResponseException {
        Document doc;
        byte[] responseBody = null;
        InputStream responseBodyStream = null;
        if (method.getResponseContentLength() != -1L && method.getResponseContentLength() <= 0x100000L) {
            try {
                responseBody = method.getResponseBody();
                responseBodyStream = new ByteArrayInputStream(responseBody);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (responseBodyStream == null) {
            try {
                responseBodyStream = method.getResponseBodyAsStream();
            }
            catch (IOException e) {
                throw new InvalidServerResponseException("Unable to parse obtain the server's response.", e);
            }
        }
        try {
            doc = DOMCreateUtils.parseStream(method.getResponseBodyAsStream(), null);
        }
        catch (Exception e) {
            if (responseBody != null) {
                String base64Body = this.getFormattedBase64Encoding(responseBody);
                String messageFormat = "unable to parse server's response body:{0}{1}";
                String message = MessageFormat.format("unable to parse server's response body:{0}{1}", NEWLINE, base64Body);
                log.warn((Object)message);
            }
            throw new InvalidServerResponseException("The server's error could not be parsed as XML.  No SOAP fault found.", e);
        }
        this.examineResponseDOMForFault(doc);
        String messageFormat = "no soap fault found in server response from 500: {0}{1}";
        String message = MessageFormat.format("no soap fault found in server response from 500: {0}{1}", NEWLINE, DOMSerializeUtils.toString(doc));
        log.warn((Object)message);
        throw new InvalidServerResponseException("The server's error could not be parsed as XML.  No SOAP fault found.");
    }

    private void examineHeadersForFederatedAuthURL(PostMethod method) throws URIException, FederatedAuthException {
        Header authenticationUrlHeader;
        Header locationHeader = method.getResponseHeader("Location");
        Header fedAuthRedirectHeader = method.getResponseHeader("X-TFS-FedAuthRedirect");
        Header fedAuthIssuerHeader = method.getResponseHeader("X-TFS-FedAuthIssuer");
        Header fedAuthRealmHeader = method.getResponseHeader("X-TFS-FedAuthRealm");
        Header fedServerErrorHeader = method.getResponseHeader("X-TFS-ServiceError");
        Header[] authenticateHeaders = method.getResponseHeaders("WWW-Authenticate");
        Credentials credentials = this.client.getState().getCredentials(AuthScope.ANY);
        String uri = method.getURI().toString();
        int statusCode = method.getStatusCode();
        Header header = authenticationUrlHeader = fedAuthRedirectHeader != null ? fedAuthRedirectHeader : locationHeader;
        if (authenticationUrlHeader != null && fedAuthIssuerHeader != null && fedAuthRealmHeader != null) {
            String authenticationUrl = null;
            String fedAuthIssuer = null;
            String fedAuthRealm = null;
            String fedServerError = null;
            String[] mechanisms = new String[]{};
            try {
                authenticationUrl = URLDecoder.decode(authenticationUrlHeader.getValue(), "UTF-8");
                fedAuthIssuer = URLDecoder.decode(fedAuthIssuerHeader.getValue(), "UTF-8");
                fedAuthRealm = URLDecoder.decode(fedAuthRealmHeader.getValue(), "UTF-8");
                fedServerError = URLDecoder.decode(fedServerErrorHeader.getValue(), "UTF-8");
                if (authenticateHeaders != null) {
                    mechanisms = new String[authenticateHeaders.length];
                    for (int i = 0; i < authenticateHeaders.length; ++i) {
                        mechanisms[i] = URLDecoder.decode(authenticateHeaders[i].getValue(), "UTF-8");
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)"Could not decode federated authentication URL as UTF-8", (Throwable)e);
            }
            if (authenticationUrl != null && fedAuthRealm != null) {
                if (statusCode == 302) {
                    throw new FederatedAuthException(uri, authenticationUrl, fedAuthIssuer, fedAuthRealm, mechanisms, credentials, fedServerError);
                }
                throw new FederatedAuthFailedException(fedServerError, fedAuthRealm);
            }
        }
        if (statusCode == 401) {
            throw new UnauthorizedException(uri, credentials);
        }
        String messageFormat = Messages.getString("SOAPService.SoapEndpointCouldNotBeContactedFormat");
        String message = MessageFormat.format(messageFormat, uri, Integer.toString(statusCode));
        throw new EndpointNotFoundException(message, statusCode);
    }

    public void examineHeadersForErrorMessage(PostMethod method) throws ServiceErrorException, EndpointNotFoundException, URIException {
        String errorMessage = this.getServerErrorMessage(method);
        if (errorMessage != null) {
            throw new ServiceErrorException(errorMessage);
        }
        String messageFormat = Messages.getString("SOAPService.SoapEndpointCouldNotBeContactedFormat");
        String message = MessageFormat.format(messageFormat, method.getURI().toString(), Integer.toString(method.getStatusCode()));
        throw new EndpointNotFoundException(message, method.getStatusCode());
    }

    private String getServerErrorMessage(PostMethod method) {
        Header serviceErrorHeader = method.getResponseHeader("X-TFS-ServiceError");
        if (serviceErrorHeader != null) {
            try {
                return URLDecoder.decode(serviceErrorHeader.getValue(), "UTF-8");
            }
            catch (Exception e) {
                log.warn((Object)"Could not decode service error message as UTF-8", (Throwable)e);
            }
        }
        return null;
    }

    protected abstract void examineResponseDOMForFault(Document var1);

    protected Node getChildByName(Node node, String childName) {
        Check.notNull(childName, "childName");
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || !child.getNodeName().equalsIgnoreCase(childName)) continue;
            return child;
        }
        return null;
    }

    public final HttpClient getHTTPClient() {
        return this.client;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public QName getPort() {
        return this.port;
    }
}

