/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.types;

import com.microsoft.tfs.core.ws.runtime.exceptions.SOAPSerializationException;
import java.text.MessageFormat;
import java.util.Map;

public abstract class Flag {
    protected final String name;

    protected Flag(String name, Map valuesToInstances) {
        this.name = name;
        valuesToInstances.put(name, this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Flag)) {
            return false;
        }
        return ((Flag)obj).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static Flag fromString(String value, Map valuesToInstances) throws SOAPSerializationException {
        Flag ret = (Flag)valuesToInstances.get(value);
        if (ret == null) {
            String messageFormat = "No flag matches the attribute value {0}";
            String message = MessageFormat.format("No flag matches the attribute value {0}", value);
            throw new SOAPSerializationException(message);
        }
        return ret;
    }
}

