/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.types;

import com.microsoft.tfs.core.ws.runtime.stax.StaxFactoryProvider;
import com.microsoft.tfs.core.ws.runtime.stax.StaxUtils;
import com.microsoft.tfs.core.ws.runtime.types.AnyContentType;
import com.microsoft.tfs.util.Closable;
import com.microsoft.tfs.util.temp.FastTempOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaxAnyContentType
implements AnyContentType {
    private static final Log log = LogFactory.getLog(StaxAnyContentType.class);
    private final List tempOutputStreams = new ArrayList();
    private int initialHeapStorageSizeBytes = -1;
    private int heapStorageLimitBytes = -1;

    public StaxAnyContentType() {
    }

    public StaxAnyContentType(int heapStorageLimitBytes, int initialHeapStorageSizeBytes) {
        this.heapStorageLimitBytes = heapStorageLimitBytes;
        this.initialHeapStorageSizeBytes = initialHeapStorageSizeBytes;
    }

    @Override
    public void dispose() {
        for (FastTempOutputStream outputStream : this.tempOutputStreams) {
            try {
                outputStream.dispose();
            }
            catch (IOException e) {
                throw new RuntimeException("Error storing temporary Stax content", e);
            }
        }
        this.tempOutputStreams.clear();
    }

    @Override
    public Iterator getElementIterator() {
        return new XMLStreamReaderIterator(this.tempOutputStreams.iterator(), StaxFactoryProvider.getXMLInputFactory(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromElement(XMLStreamReader reader) throws XMLStreamException {
        FastTempOutputStream ftos = null;
        XMLStreamWriter writer = null;
        int event = reader.next();
        do {
            if (event != 1) continue;
            try {
                ftos = new FastTempOutputStream(this.heapStorageLimitBytes, this.initialHeapStorageSizeBytes);
                this.tempOutputStreams.add(ftos);
                writer = StaxFactoryProvider.getXMLOutputFactory().createXMLStreamWriter(ftos, "utf-8");
                writer.writeStartDocument();
                StaxUtils.copyCurrentElement(reader, writer);
                writer.writeEndDocument();
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (ftos != null) {
                    try {
                        ftos.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            }
        } while ((event = reader.next()) != 2);
    }

    @Override
    public void writeAsElement(XMLStreamWriter writer, String name) throws XMLStreamException {
        Iterator i = this.getElementIterator();
        while (i.hasNext()) {
            XMLStreamReader reader = (XMLStreamReader)i.next();
            reader.next();
            StaxUtils.copyCurrentElement(reader, writer);
            reader.close();
        }
        if (i instanceof Closable) {
            ((Closable)((Object)i)).close();
        }
    }

    private static class XMLStreamReaderIterator
    implements Iterator,
    Closable {
        private final Iterator outputStreamIterator;
        private final XMLInputFactory inputFactory;
        private final List<InputStream> tempInputStreams;

        public XMLStreamReaderIterator(Iterator fileIterator, XMLInputFactory inputFactory) {
            this.outputStreamIterator = fileIterator;
            this.inputFactory = inputFactory;
            this.tempInputStreams = new ArrayList<InputStream>();
        }

        @Override
        public boolean hasNext() {
            return this.outputStreamIterator.hasNext();
        }

        public Object next() {
            FastTempOutputStream ftos = (FastTempOutputStream)this.outputStreamIterator.next();
            try {
                InputStream inputStream = ftos.getInputStream();
                this.tempInputStreams.add(inputStream);
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(inputStream, "utf-8");
                return reader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            this.outputStreamIterator.remove();
        }

        @Override
        public void close() {
            for (InputStream inputStream : this.tempInputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Cannot close input stream.", (Throwable)e);
                }
            }
        }
    }
}

