/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream.decoder.entry;

import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedEntryDescriptor;
import com.microsoft.tfs.jni.appleforked.fileformat.entry.AppleForkedDateEntry;
import com.microsoft.tfs.jni.appleforked.stream.decoder.entry.AppleForkedEntryDecoder;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.chunkingcodec.ByteArrayChunkedDecoder;
import java.io.File;
import java.util.Date;

public class AppleForkedDateDecoder
extends ByteArrayChunkedDecoder
implements AppleForkedEntryDecoder {
    private final File file;
    private Date modifiedTime = null;

    protected AppleForkedDateDecoder(AppleForkedEntryDescriptor descriptor, File file) {
        super((int)descriptor.getLength());
        Check.isTrue(descriptor.getType() == 8L, "descriptor.getType() == AppleForkedConstants.ID_DATEINFO");
        Check.isTrue(descriptor.getLength() == 16L, "descriptor.getLength() == AppleForkedDateEntry.DATE_ENTRY_SIZE");
        Check.notNull(file, "file");
        this.file = file;
    }

    @Override
    protected void finish(byte[] buffer) {
        AppleForkedDateEntry dateEntry = new AppleForkedDateEntry(buffer);
        this.modifiedTime = dateEntry.getModificationDate();
    }

    @Override
    public void close() {
        if (this.modifiedTime != null) {
            this.file.setLastModified(this.modifiedTime.getTime());
        }
    }
}

