/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream.encoder.entry;

import com.microsoft.tfs.jni.appleforked.fileformat.entry.AppleForkedDateEntry;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedEntryEncoder;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.chunkingcodec.ByteArrayChunkedEncoder;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class AppleForkedDateEncoder
extends ByteArrayChunkedEncoder
implements AppleForkedEntryEncoder {
    private File file;
    private Date date;

    public AppleForkedDateEncoder(File file) {
        this.file = file;
    }

    public AppleForkedDateEncoder(Date date) {
        this.date = date;
    }

    @Override
    public long getType() {
        return 8L;
    }

    @Override
    public long getLength() {
        return 16L;
    }

    @Override
    protected byte[] start() throws IOException {
        Date modifiedDate;
        if (this.date != null) {
            modifiedDate = this.date;
        } else if (this.file != null) {
            if (!this.file.exists()) {
                throw new IOException("File does not exist");
            }
            modifiedDate = new Date(this.file.lastModified());
        } else {
            modifiedDate = new Date();
        }
        AppleForkedDateEntry dateEntry = new AppleForkedDateEntry(modifiedDate, modifiedDate, null, null);
        byte[] dateData = dateEntry.encode();
        Check.isTrue(dateData.length == 16, "dateData.length == AppleForkedDateEntry.DATE_ENTRY_SIZE");
        return dateData;
    }

    @Override
    public void close() {
    }
}

