/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream.encoder.entry;

import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedEntryEncoder;
import com.microsoft.tfs.util.chunkingcodec.ByteArrayChunkedEncoder;
import java.io.File;
import java.io.IOException;

public class AppleForkedFinderInfoEncoder
extends ByteArrayChunkedEncoder
implements AppleForkedEntryEncoder {
    private final byte[] finderInfo;

    public AppleForkedFinderInfoEncoder(File file) {
        byte[] finderInfo = FileSystemUtils.getInstance().getMacExtendedAttribute(AppleForkedFinderInfoEncoder.getFilename(file), "com.apple.FinderInfo");
        this.finderInfo = finderInfo != null ? finderInfo : new byte[]{};
    }

    private static String getFilename(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    @Override
    public long getType() {
        return 9L;
    }

    @Override
    public long getLength() {
        return this.finderInfo.length;
    }

    @Override
    protected byte[] start() throws IOException {
        return this.finderInfo;
    }

    @Override
    public void close() throws IOException {
    }
}

