/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.helpers;

import com.microsoft.tfs.jni.PlatformMiscUtils;
import com.microsoft.tfs.util.Platform;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LocalHost {
    public static final int MAX_COMPUTER_NAME_SIZE = 31;
    private static final Log log = LogFactory.getLog(LocalHost.class);
    public static final String SHORT_NAME_OVERRIDE_PROPERTY = "computerName";
    private static String computerName;

    public static synchronized String getShortName() {
        if (computerName == null) {
            String name = null;
            name = LocalHost.getSystemPropertyShortName();
            if (name == null) {
                name = LocalHost.getNativeShortName();
            }
            if (name == null) {
                name = LocalHost.getEnvironmentShortName();
            }
            if (name == null) {
                name = LocalHost.getPureJavaShortName();
            }
            if (name == null || name.length() == 0) {
                name = LocalHost.getMadeUpShortName();
            }
            computerName = name.substring(0, name.length() > 31 ? 31 : name.length());
        }
        return computerName;
    }

    private static String getEnvironmentShortName() {
        String computerName;
        if (Platform.isCurrentPlatform(Platform.WINDOWS) && (computerName = PlatformMiscUtils.getInstance().getEnvironmentVariable("COMPUTERNAME")) != null && computerName.length() > 0) {
            return computerName;
        }
        return null;
    }

    private static String getNativeShortName() {
        String name = PlatformMiscUtils.getInstance().getComputerName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return null;
    }

    private static String getSystemPropertyShortName() {
        String name = System.getProperty(SHORT_NAME_OVERRIDE_PROPERTY);
        if (name != null && name.length() > 0) {
            return name;
        }
        return null;
    }

    private static String getMadeUpShortName() {
        String username = System.getProperty("user.name");
        if (username != null) {
            StringBuffer newUsername = new StringBuffer();
            for (int i = 0; i < username.length(); ++i) {
                char c = username.charAt(i);
                if (!Character.isLetterOrDigit(c)) continue;
                newUsername.append(c);
            }
            username = newUsername.toString();
        }
        if (username != null && username.length() != 0) {
            return username + "Computer";
        }
        log.warn((Object)MessageFormat.format("Could not make a hostname from the username '{0}' because it had no usable characters", username));
        return "TEEComputer";
    }

    private static String getPureJavaShortName() {
        String name = null;
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            name = localMachine.getHostName();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Pure Java host name lookup failed", (Throwable)e);
            return null;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }
}

