/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.internal.keychain;

import com.microsoft.tfs.jni.Keychain;
import com.microsoft.tfs.jni.KeychainInternetPassword;
import com.microsoft.tfs.jni.loader.NativeLoader;
import com.microsoft.tfs.util.Check;

public class NativeKeychain
implements Keychain {
    @Override
    public boolean addInternetPassword(KeychainInternetPassword password, boolean allowUi) {
        Check.notNull(password, "password");
        return NativeKeychain.nativeAddInternetPassword(password, allowUi);
    }

    @Override
    public boolean modifyInternetPassword(KeychainInternetPassword oldPassword, KeychainInternetPassword newPassword, boolean allowUi) {
        Check.notNull(oldPassword, "oldPassword");
        Check.notNull(newPassword, "newPassword");
        return NativeKeychain.nativeModifyInternetPassword(oldPassword, newPassword, allowUi);
    }

    @Override
    public KeychainInternetPassword findInternetPassword(KeychainInternetPassword password, boolean allowUi) {
        Check.notNull(password, "password");
        return (KeychainInternetPassword)NativeKeychain.nativeFindInternetPassword(password, allowUi);
    }

    @Override
    public boolean removeInternetPassword(KeychainInternetPassword password, boolean allowUi) {
        Check.notNull(password, "password");
        return NativeKeychain.nativeRemoveInternetPassword(password, allowUi);
    }

    private static native boolean nativeAddInternetPassword(Object var0, boolean var1);

    private static native boolean nativeModifyInternetPassword(Object var0, Object var1, boolean var2);

    private static native Object nativeFindInternetPassword(Object var0, boolean var1);

    private static native boolean nativeRemoveInternetPassword(Object var0, boolean var1);

    static {
        NativeLoader.loadLibraryAndLogError("native_keychain");
    }
}

