/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.internal.negotiate;

import com.microsoft.tfs.jni.Messages;
import com.microsoft.tfs.jni.Negotiate;
import com.microsoft.tfs.jni.internal.auth.NativeAuth;
import com.microsoft.tfs.jni.internal.negotiate.NegotiateException;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import java.text.MessageFormat;

public class NativeNegotiate
implements Negotiate {
    public static boolean isAvailable() {
        if (Platform.isCurrentPlatform(Platform.HPUX) && "PA_RISC2.0".equals(System.getProperty("os.arch")) && System.getProperty("eclipse.product") != null) {
            return false;
        }
        try {
            return NativeAuth.authAvailable((short)2);
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    @Override
    public synchronized boolean supportsCredentialsDefault() {
        return NativeAuth.authSupportsCredentialsDefault((short)2);
    }

    @Override
    public synchronized boolean supportsCredentialsSpecified() {
        return NativeAuth.authSupportsCredentialsSpecified((short)2);
    }

    @Override
    public synchronized String getCredentialsDefault() {
        return NativeAuth.authGetCredentialsDefault((short)2);
    }

    @Override
    public synchronized Negotiate.NegotiateState initialize() throws NegotiateException {
        try {
            long id = NativeAuth.authInitialize((short)2);
            if (id == 0L) {
                throw new NegotiateException(Messages.getString("NativeNegotiate.CouldNotInitializeNegotiateLibraries"));
            }
            return new NativeNegotiateState(id);
        }
        catch (Exception e) {
            throw new NegotiateException(e.getMessage());
        }
    }

    @Override
    public synchronized void setCredentialsDefault(Negotiate.NegotiateState state) throws NegotiateException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNegotiateState, "state instanceof NativeNegotiateState");
        try {
            NativeAuth.authSetCredentialsDefault(((NativeNegotiateState)state).id);
        }
        catch (Exception e) {
            throw new NegotiateException(e.getMessage());
        }
    }

    @Override
    public synchronized void setCredentialsSpecified(Negotiate.NegotiateState state, String username, String domain, String password) throws NegotiateException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNegotiateState, "state instanceof NativeNegotiateState");
        try {
            NativeAuth.authSetCredentialsSpecified(((NativeNegotiateState)state).id, username, domain, password);
        }
        catch (Exception e) {
            throw new NegotiateException(e.getMessage());
        }
    }

    @Override
    public synchronized void setLocalhost(Negotiate.NegotiateState state, String localhost) throws NegotiateException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNegotiateState, "state instanceof NativeNegotiateState");
        try {
            NativeAuth.authSetLocalhost(((NativeNegotiateState)state).id, localhost != null ? localhost : "");
        }
        catch (Exception e) {
            throw new NegotiateException(e.getMessage());
        }
    }

    @Override
    public synchronized void setTarget(Negotiate.NegotiateState state, String target) throws NegotiateException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNegotiateState, "state instanceof NativeNegotiateState");
        try {
            NativeAuth.authSetTarget(((NativeNegotiateState)state).id, target != null ? target : "");
        }
        catch (Exception e) {
            throw new NegotiateException(e.getMessage());
        }
    }

    @Override
    public synchronized byte[] getToken(Negotiate.NegotiateState state, byte[] inputToken) throws NegotiateException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNegotiateState, "state instanceof NativeNegotiateState");
        try {
            return NativeAuth.authGetToken(((NativeNegotiateState)state).id, inputToken);
        }
        catch (Exception e) {
            throw new NegotiateException(e.getMessage());
        }
    }

    @Override
    public synchronized boolean isComplete(Negotiate.NegotiateState state) throws NegotiateException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNegotiateState, "state instanceof NativeNegotiateState");
        try {
            return NativeAuth.authIsComplete(((NativeNegotiateState)state).id);
        }
        catch (Exception e) {
            throw new NegotiateException(e.getMessage());
        }
    }

    @Override
    public synchronized String getErrorMessage(Negotiate.NegotiateState state) {
        Check.notNull(state, "state");
        try {
            return NativeAuth.authGetErrorMessage(((NativeNegotiateState)state).id);
        }
        catch (Exception e) {
            return MessageFormat.format(Messages.getString("NativeNegotiate.CouldNotCallNativeNegotiateFormat"), e.getLocalizedMessage());
        }
    }

    @Override
    public synchronized void dispose(Negotiate.NegotiateState state) throws NegotiateException {
        Check.notNull(state, "state");
        Check.isTrue(state instanceof NativeNegotiateState, "state instanceof NativeNegotiateState");
        try {
            NativeAuth.authDispose(((NativeNegotiateState)state).id);
        }
        catch (Exception e) {
            throw new NegotiateException(e.getMessage());
        }
    }

    private static class NativeNegotiateState
    extends Negotiate.NegotiateState {
        private long id = 0L;

        public NativeNegotiateState(long id) {
            this.id = id;
        }
    }
}

