/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.internal.synchronization;

import com.microsoft.tfs.jni.Synchronization;
import com.microsoft.tfs.jni.loader.NativeLoader;
import com.microsoft.tfs.util.Check;

public class NativeSynchronization
implements Synchronization {
    @Override
    public long createMutex(String name) {
        Check.notNull(name, "name");
        return NativeSynchronization.nativeCreateMutex(name);
    }

    @Override
    public int waitForMutex(long mutexId, int timeout) {
        Check.isTrue(mutexId >= 0L, "mutexId >= 0");
        return NativeSynchronization.nativeWaitForMutex(mutexId, timeout);
    }

    @Override
    public boolean releaseMutex(long mutexId) {
        Check.isTrue(mutexId >= 0L, "mutexId >= 0");
        return NativeSynchronization.nativeReleaseMutex(mutexId);
    }

    @Override
    public boolean closeMutex(long mutexId) {
        Check.isTrue(mutexId >= 0L, "mutexId >= 0");
        return NativeSynchronization.nativeCloseMutex(mutexId);
    }

    @Override
    public long createSemaphore(String name, int initialValue) {
        Check.notNull(name, "name");
        return NativeSynchronization.nativeCreateSemaphore(name, initialValue);
    }

    @Override
    public int waitForSemaphore(long semaphoreId, int timeout) {
        Check.isTrue(semaphoreId >= 0L, "semaphoreId >= 0");
        return NativeSynchronization.nativeWaitForSemaphore(semaphoreId, timeout);
    }

    @Override
    public boolean releaseSemaphore(long semaphoreId) {
        Check.isTrue(semaphoreId >= 0L, "semaphoreId >= 0");
        return NativeSynchronization.nativeReleaseSemaphore(semaphoreId);
    }

    @Override
    public boolean closeSemaphore(long semaphoreId) {
        Check.isTrue(semaphoreId >= 0L, "semaphoreId >= 0");
        return NativeSynchronization.nativeCloseSemaphore(semaphoreId);
    }

    private static native long nativeCreateMutex(String var0);

    private static native int nativeWaitForMutex(long var0, int var2);

    private static native boolean nativeReleaseMutex(long var0);

    private static native boolean nativeCloseMutex(long var0);

    private static native long nativeCreateSemaphore(String var0, int var1);

    private static native int nativeWaitForSemaphore(long var0, int var2);

    private static native boolean nativeReleaseSemaphore(long var0);

    private static native boolean nativeCloseSemaphore(long var0);

    static {
        NativeLoader.loadLibraryAndLogError("native_synchronization");
    }
}

