/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import java.lang.reflect.Array;

public class ArrayUtils {
    private static final char[] LCASE_HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final char[] UCASE_HEX_CHARS = "0123456789ABCDEF".toCharArray();

    public static Object[] convert(Object[] a, Class componentType) {
        Check.notNull(componentType, "componentType");
        if (a == null) {
            return null;
        }
        if (componentType.isPrimitive()) {
            throw new IllegalArgumentException("component type is primitive");
        }
        Object[] x = (Object[])Array.newInstance(componentType, a.length);
        System.arraycopy(a, 0, x, 0, a.length);
        return x;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        return ArrayUtils.byteArrayToHexString(bytes, true);
    }

    public static String byteArrayToHexStringUpperCase(byte[] bytes) {
        return ArrayUtils.byteArrayToHexString(bytes, true);
    }

    public static String byteArrayToHexStringLowerCase(byte[] bytes) {
        return ArrayUtils.byteArrayToHexString(bytes, false);
    }

    public static <T> T[] concat(T[] a, T b) {
        if (b == null) {
            return ArrayUtils.concat(a, null);
        }
        Object[] bArray = (Object[])Array.newInstance(a != null ? a.getClass().getComponentType() : b.getClass(), 1);
        bArray[0] = b;
        return ArrayUtils.concat(a, bArray);
    }

    public static <T> T[] concat(T[] a, T[] b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return (Object[])b.clone();
        }
        if (b == null) {
            return (Object[])a.clone();
        }
        Object[] ret = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
        System.arraycopy(a, 0, ret, 0, a.length);
        System.arraycopy(b, 0, ret, a.length, b.length);
        return ret;
    }

    private static String byteArrayToHexString(byte[] bytes, boolean upperCase) {
        Check.notNull(bytes, "bytes");
        char[] chars = upperCase ? UCASE_HEX_CHARS : LCASE_HEX_CHARS;
        StringBuffer buffer = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append(chars[(bytes[i] & 0xF0) >> 4]);
            buffer.append(chars[bytes[i] & 0xF]);
        }
        return buffer.toString();
    }
}

