/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

public abstract class Check {
    public static void notNull(Object o, String variableName) {
        if (o == null) {
            Check.throwForNull(variableName);
        }
    }

    public static void notEmpty(String string, String variableName) {
        if (string != null && string.length() == 0) {
            Check.throwForEmpty(variableName);
        }
    }

    public static void notNullOrEmpty(String string, String variableName) {
        if (string == null) {
            Check.throwForNull(variableName);
        }
        if (string.length() == 0) {
            Check.throwForEmpty(variableName);
        }
    }

    public static void notNullOrEmpty(Object[] array, String variableName) {
        if (array == null) {
            Check.throwForNull(variableName);
        }
        if (array.length == 0) {
            Check.throwForEmpty(variableName);
        }
    }

    public static void isTrue(boolean condition) {
        Check.isTrue(condition, null);
    }

    public static void isTrue(boolean condition, String message) {
        if (!condition) {
            Check.throwForFalse(message);
        }
    }

    private static void throwForNull(String variableName) {
        if (variableName == null) {
            variableName = "argument";
        }
        throw new NullPointerException(variableName + " must not be null");
    }

    private static void throwForEmpty(String variableName) {
        if (variableName == null) {
            variableName = "argument";
        }
        throw new IllegalArgumentException(variableName + " must not be empty");
    }

    private static void throwForFalse(String message) {
        if (message == null) {
            message = "condition must not be false";
        }
        throw new IllegalArgumentException(message);
    }
}

