/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.chunkingcodec;

import com.microsoft.tfs.util.chunkingcodec.ChunkedDecoder;
import java.io.IOException;

public abstract class ByteArrayChunkedDecoder
implements ChunkedDecoder {
    private final byte[] buffer;
    private int bufferLen = 0;
    private boolean complete = false;

    protected ByteArrayChunkedDecoder(int bufferSize) {
        this.buffer = new byte[bufferSize];
    }

    @Override
    public final int decode(byte[] buf, int off, int len) {
        int writeLen = Math.min(this.buffer.length - this.bufferLen, len);
        System.arraycopy(buf, off, this.buffer, this.bufferLen, writeLen);
        this.bufferLen += writeLen;
        if (this.bufferLen == this.buffer.length) {
            this.complete = true;
            this.finish(this.buffer);
        }
        return writeLen;
    }

    @Override
    public final boolean isComplete() {
        return this.complete;
    }

    protected abstract void finish(byte[] var1);

    public void close() throws IOException {
    }
}

