/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.chunkingcodec;

import com.microsoft.tfs.util.chunkingcodec.ChunkedEncoder;
import java.io.IOException;

public abstract class ByteArrayChunkedEncoder
implements ChunkedEncoder {
    private byte[] buffer;
    private int bufferLen = 0;
    private boolean complete = false;

    protected ByteArrayChunkedEncoder() {
    }

    protected abstract byte[] start() throws IOException;

    @Override
    public final int encode(byte[] buf, int off, int len) throws IOException {
        if (this.buffer == null) {
            this.buffer = this.start();
            if (this.buffer == null) {
                throw new IOException("Could not get byte buffer");
            }
        }
        int writeLen = Math.min(this.buffer.length - this.bufferLen, len);
        System.arraycopy(this.buffer, this.bufferLen, buf, off, writeLen);
        this.bufferLen += writeLen;
        if (this.bufferLen == this.buffer.length) {
            this.complete = true;
        }
        return writeLen;
    }

    @Override
    public final boolean isComplete() {
        return this.complete;
    }
}

