/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.listeners;

import java.util.Comparator;

public class Comparators {
    public static final Comparator EQUALITY = new EqualityComparator();
    public static final Comparator IDENTITY = new IdentityComparator();

    private static class IdentityComparator
    implements Comparator {
        private IdentityComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            return System.identityHashCode(o1) - System.identityHashCode(o2);
        }
    }

    private static class EqualityComparator
    implements Comparator {
        private EqualityComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            return o1.hashCode() - o2.hashCode();
        }
    }
}

