/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.listeners;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.DefaultExceptionHandler;
import com.microsoft.tfs.util.listeners.ListenerExceptionHandler;
import com.microsoft.tfs.util.listeners.ListenerList;
import com.microsoft.tfs.util.listeners.ListenerRunnable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MulticastListenerProxy {
    private static final Log log = LogFactory.getLog(MulticastListenerProxy.class);

    public static Object createProxy(Class listenerInterface, ListenerList listenerList) {
        return MulticastListenerProxy.createProxy(listenerInterface, listenerList, DefaultExceptionHandler.INSTANCE);
    }

    public static Object createProxy(Class listenerInterface, ListenerList listenerList, ListenerExceptionHandler exceptionHandler) {
        Check.notNull(listenerInterface, "listenerInterface");
        Check.notNull(listenerList, "listenerList");
        Check.notNull(exceptionHandler, "exceptionHandler");
        Class[] classesToProxy = new Class[]{listenerInterface};
        MLPInvocationHandler invocationHandler = new MLPInvocationHandler(listenerList, exceptionHandler);
        return Proxy.newProxyInstance(listenerInterface.getClassLoader(), classesToProxy, (InvocationHandler)invocationHandler);
    }

    private static class MLPInvocationHandler
    implements InvocationHandler {
        private final ListenerList listenerList;
        private final ListenerExceptionHandler exceptionHandler;

        private MLPInvocationHandler(ListenerList listenerList, ListenerExceptionHandler exceptionHandler) {
            this.listenerList = listenerList;
            this.exceptionHandler = new ExceptionHandlerWrapper(exceptionHandler);
        }

        @Override
        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            this.listenerList.foreachListener(this.exceptionHandler, new ListenerRunnable(){

                @Override
                public boolean run(Object listener) throws Exception {
                    method.invoke(listener, args);
                    return true;
                }
            });
            return null;
        }

        private static class ExceptionHandlerWrapper
        implements ListenerExceptionHandler {
            private final ListenerExceptionHandler wrappedExceptionHandler;

            public ExceptionHandlerWrapper(ListenerExceptionHandler wrappedExceptionHandler) {
                this.wrappedExceptionHandler = wrappedExceptionHandler;
            }

            @Override
            public boolean onException(Object listener, ListenerRunnable listenerRunnable, ListenerList listenerList, Throwable exception) {
                if (exception instanceof InvocationTargetException) {
                    return this.wrappedExceptionHandler.onException(listener, listenerRunnable, listenerList, ((InvocationTargetException)exception).getTargetException());
                }
                log.error((Object)"invalid configuration detected", exception);
                return true;
            }
        }
    }
}

