/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.badge;

import com.teamscale.core.utils.VelocityEngineUtils;
import com.teamscale.service.framework.badge.Segment;
import com.teamscale.service.framework.badge.SegmentBuilder;
import com.teamscale.service.framework.badge.sections.EBadgeIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BadgeBuilder {
    private static final String BADGE_TEMPLATE_PATH = "com/teamscale/service/framework/badge/badge-template.vm";
    private static final String TEMPLATE_FULL_WIDTH_IDENTIFIER = "fullWidth";
    private static final String TEMPLATE_SEGMENTS_IDENTIFIER = "segments";
    List<Segment> segments = new ArrayList<Segment>();
    private static final int DEFAULT_TEXT_SEGMENT_MARGIN = 6;

    public SegmentBuilder.RequireStyle segment() {
        return style -> new SegmentBuilder(this, style);
    }

    public SegmentBuilder.RequireStyle textSegment(String text) {
        return style -> new SegmentBuilder(this, style).air(6.0).text(text).air(6.0);
    }

    public SegmentBuilder.RequireStyle iconTextSegment(EBadgeIcon icon, String text, int margin) {
        return style -> new SegmentBuilder(this, style).air(margin).icon(icon).air(margin).text(text).air(margin);
    }

    public double getFullWidth() {
        return this.segments.stream().mapToDouble(Segment::getWidth).sum();
    }

    public String toSvg() {
        return Arrays.stream(VelocityEngineUtils.renderTemplate((String)BADGE_TEMPLATE_PATH, Map.of(TEMPLATE_SEGMENTS_IDENTIFIER, this.segments, TEMPLATE_FULL_WIDTH_IDENTIFIER, this.getFullWidth())).split("\n")).map(String::trim).filter(line -> !line.isBlank()).map(line -> line.startsWith("<") ? line : " " + line).collect(Collectors.joining());
    }
}

