/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.badge;

import com.teamscale.service.framework.badge.BadgeBuilder;
import com.teamscale.service.framework.badge.Segment;
import com.teamscale.service.framework.badge.SegmentStyle;
import com.teamscale.service.framework.badge.sections.AirSection;
import com.teamscale.service.framework.badge.sections.EBadgeIcon;
import com.teamscale.service.framework.badge.sections.IconSection;
import com.teamscale.service.framework.badge.sections.SectionBase;
import com.teamscale.service.framework.badge.sections.TextSection;
import org.jspecify.annotations.Nullable;

public class SegmentBuilder
extends Segment {
    private final BadgeBuilder badgeBuilder;

    public SegmentBuilder(BadgeBuilder badgeBuilder, SegmentStyle style) {
        this.badgeBuilder = badgeBuilder;
        this.style = style;
    }

    public double getNextSectionStartX() {
        return this.badgeBuilder.getFullWidth() + this.getWidth();
    }

    public SegmentBuilder tooltip(@Nullable String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public SegmentBuilder air(double airWidth) {
        if (airWidth < 0.0 || Double.isNaN(airWidth)) {
            throw new IllegalArgumentException("Air width must be a non-negative number.");
        }
        this.sections.add(new AirSection(this.getNextSectionStartX(), airWidth));
        return this;
    }

    public SegmentBuilder text(String text) {
        return this.text().content(text).finishText();
    }

    public TextSection.Builder.RequireText text() {
        return text -> new TextSection.Builder(this, text);
    }

    public SegmentBuilder icon(EBadgeIcon icon) {
        this.sections.add(new IconSection(this.getNextSectionStartX(), icon));
        return this;
    }

    public SegmentBuilder addSection(SectionBase section) {
        this.sections.add(section);
        return this;
    }

    public BadgeBuilder append() {
        if (!this.sections.isEmpty()) {
            this.badgeBuilder.segments.add(this);
        }
        return this.badgeBuilder;
    }

    @FunctionalInterface
    public static interface RequireStyle {
        public SegmentBuilder style(SegmentStyle var1);
    }
}

