/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.badge;

import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class SegmentStyle {
    private final String backgroundColor;
    private final String textColor;
    public static final SegmentStyle RED = new SegmentStyle("#f8e3e4", "#9d362a");
    public static final SegmentStyle GREEN = new SegmentStyle("#e3f6e7", "#3f7f4d");
    public static final SegmentStyle BLUE = new SegmentStyle("#e4edfd", "#485fa6");
    public static final SegmentStyle YELLOW = new SegmentStyle("#fff3bf", "#f59f00");
    public static final SegmentStyle ORANGE = new SegmentStyle("#fce9df", "#bc4624");
    public static final SegmentStyle GRAY = new SegmentStyle("#dee2e6", "#212529");
    public static final SegmentStyle BLACK = new SegmentStyle("#000", "#fff");
    public static final SegmentStyle WHITE = new SegmentStyle("#fff", "#000");
    public static final SegmentStyle TITLE = new SegmentStyle("#555", "#fff");
    public static final SegmentStyle DARK_BLUE = new SegmentStyle("#1f75cb", "#fff");
    private static final String DEFAULT_TEXT_COLOR = "#fff";

    private SegmentStyle(String backgroundColor, String textColor) {
        this.backgroundColor = backgroundColor;
        this.textColor = textColor;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public SegmentStyle withBackgroundColor(String backgroundColor) {
        return new SegmentStyle(backgroundColor, this.textColor);
    }

    public SegmentStyle withTextColor(String textColor) {
        return new SegmentStyle(this.backgroundColor, textColor);
    }

    public static SegmentStyle of(String backgroundColor, String textColor) {
        return new SegmentStyle(backgroundColor, textColor);
    }

    public static SegmentStyle of(String backgroundColor) {
        return new SegmentStyle(backgroundColor, DEFAULT_TEXT_COLOR);
    }

    public static SegmentStyle fromTrafficLightColor(ETrafficLightColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case ETrafficLightColor.RED -> RED;
            case ETrafficLightColor.ORANGE -> ORANGE;
            case ETrafficLightColor.YELLOW -> YELLOW;
            case ETrafficLightColor.GREEN -> GREEN;
            case ETrafficLightColor.BASELINE, ETrafficLightColor.UNKNOWN -> BLACK;
        };
    }
}

