/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.badge.info;

import com.teamscale.service.framework.badge.BadgeBuilder;
import com.teamscale.service.framework.badge.SegmentStyle;
import org.conqat.lib.commons.string.StringUtils;

public class InfoBadgeCreator {
    private static final int INFO_BADGE_MARGIN = 5;
    private static final int MIN_INFO_BADGE_WIDTH = 80;
    private static final int MAX_INFO_BADGE_TEXT_LENGTH = 50;

    public static byte[] createUnauthorizedBadge() {
        return StringUtils.stringToBytes((String)InfoBadgeCreator.getInfoBadge("Not Authorized", SegmentStyle.ORANGE));
    }

    public static byte[] createErrorBadgeWithMessage(String message) {
        return StringUtils.stringToBytes((String)InfoBadgeCreator.getInfoBadge(message, SegmentStyle.RED));
    }

    public static byte[] createInsufficientRightsBadge() {
        return StringUtils.stringToBytes((String)InfoBadgeCreator.getInfoBadge("Forbidden", SegmentStyle.RED));
    }

    private static String getInfoBadge(String text, SegmentStyle style) {
        String truncatedText = StringUtils.truncateWithThreeDots((String)text, (int)50);
        return new BadgeBuilder().segment().style(style).air(5.0).text().content(truncatedText).minWidth(80.0).finishText().air(5.0).append().toSvg();
    }
}

