/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.badge.sections;

import com.teamscale.service.framework.badge.SegmentBuilder;
import com.teamscale.service.framework.badge.SvgUtils;
import com.teamscale.service.framework.badge.sections.ESectionType;
import com.teamscale.service.framework.badge.sections.SectionBase;

public class TextSection
extends SectionBase {
    private final String text;
    private final ETextAnchor anchor;

    private TextSection(double x, double width, ETextAnchor anchor, String text) {
        super(ESectionType.TEXT, x, width);
        this.text = text;
        this.anchor = anchor;
    }

    public String getText() {
        return this.text;
    }

    public String getTextAnchor() {
        return this.anchor.name().toLowerCase();
    }

    public double getX() {
        return switch (this.anchor.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.getStartX();
            case 1 -> this.getMiddleX();
            case 2 -> this.getEndX();
        };
    }

    public static enum ETextAnchor {
        START,
        MIDDLE,
        END;

    }

    public static class Builder {
        private final SegmentBuilder segmentBuilder;
        private final String text;
        private double minWidth = 0.0;
        private double maxWidth = Double.POSITIVE_INFINITY;
        private ETextAnchor anchor = ETextAnchor.MIDDLE;

        public Builder(SegmentBuilder segmentBuilder, String text) {
            this.segmentBuilder = segmentBuilder;
            this.text = text;
        }

        public Builder minWidth(double minWidth) {
            this.minWidth = minWidth;
            return this;
        }

        public Builder maxWidth(double maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public Builder anchor(ETextAnchor anchor) {
            this.anchor = anchor;
            return this;
        }

        public SegmentBuilder finishText() {
            double textWidth = SvgUtils.computeTextWidth(this.text);
            double width = Math.max(this.minWidth, Math.min(textWidth, this.maxWidth));
            TextSection section = new TextSection(this.segmentBuilder.getNextSectionStartX(), width, this.anchor, this.text);
            return this.segmentBuilder.addSection(section);
        }

        @FunctionalInterface
        public static interface RequireText {
            public Builder content(String var1);
        }
    }
}

