/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.cache.etag;

import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.cache.etag.IETagContributor;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.ArrayList;
import java.util.Collection;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class CombiningContributor
implements IETagContributor {
    private final UnmodifiableList<IETagContributor> delegateContributors;

    protected CombiningContributor(Collection<? extends IETagContributor> delegateContributors) {
        CCSMAssert.isNotNull(delegateContributors, () -> String.format("Expected \"%s\" to be not null", "delegateContributors"));
        if (delegateContributors.isEmpty()) {
            throw new IllegalArgumentException("delegateContributors must not be empty");
        }
        this.delegateContributors = CollectionUtils.asUnmodifiable(new ArrayList<IETagContributor>(delegateContributors));
    }

    @Override
    public final String generateETagFragment(ContainerRequestContext requestContext, ITeamscaleServiceInfo serviceInfo) throws Exception {
        ArrayList<String> etagFragments = new ArrayList<String>(this.delegateContributors.size());
        for (IETagContributor delegateContributor : this.delegateContributors) {
            etagFragments.add(delegateContributor.generateETagFragment(requestContext, serviceInfo));
        }
        return String.join((CharSequence)"|", etagFragments);
    }
}

