/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.cache.etag;

import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.cache.etag.IETagContributor;
import jakarta.ws.rs.container.ContainerRequestContext;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IChangeTrackingIndex;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public abstract class IndexLastChangeContributorBase
implements IETagContributor {
    @Override
    public String generateETagFragment(ContainerRequestContext requestContext, ITeamscaleServiceInfo serviceInfo) throws Exception {
        IChangeTrackingIndex index = this.openIndex(serviceInfo, requestContext);
        return String.valueOf(index.getLastChangeTimestamp().orElse(-1L));
    }

    protected abstract IChangeTrackingIndex openIndex(ITeamscaleServiceInfo var1, ContainerRequestContext var2) throws Exception;

    protected static HistoryAccessOption determineHistoryOption(ITeamscaleServiceInfo serviceInfo, ContainerRequestContext requestContext) throws StorageException {
        String timestamp = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"t");
        if (timestamp != null) {
            return HistoryAccessOption.readCommit((CommitDescriptor)IndexLastChangeContributorBase.parseCommit(serviceInfo, timestamp));
        }
        return IndexLastChangeContributorBase.readDefaultBranchHead(serviceInfo);
    }

    private static CommitDescriptor parseCommit(ITeamscaleServiceInfo serviceInfo, String commitString) throws StorageException {
        return UnresolvedCommitDescriptorUtils.parseAndResolveCommit((String)commitString, () -> serviceInfo.getProjectStorageSystem());
    }

    private static HistoryAccessOption readDefaultBranchHead(ITeamscaleServiceInfo serviceInfo) throws StorageException {
        String defaultBranchName = ((MetaIndex)serviceInfo.getProjectStorageSystem().openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
        if (defaultBranchName != null) {
            return HistoryAccessOption.readHead((String)defaultBranchName);
        }
        return HistoryAccessOption.readHeadUnbranched();
    }
}

