/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.logging;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.core.logging.ELogLevel;

public class LogFilteringParameters {
    @JsonProperty(value="minLogLevel")
    @QueryParam(value="minLogLevel")
    @Parameter(description="The minimum log level to retrieve log entries for. This includes all levels that are more severe than the given one.")
    @DefaultValue(value="INFO")
    private ELogLevel minLogLevel;
    @JsonProperty(value="maxResults")
    @QueryParam(value="maxResults")
    @Parameter(description="The maximum number of log entries to return, or 0 to return all entries.")
    @DefaultValue(value="100")
    private int maxResults;
    @JsonProperty(value="startTimestamp")
    @QueryParam(value="startTimestamp")
    @Parameter(description="The timestamp of the earliest log entry to include. If greater than endTimestamp, sort order is inverted.")
    private long startTimestamp;
    @JsonProperty(value="endTimestamp")
    @QueryParam(value="endTimestamp")
    @Parameter(description="The timestamp of the latest log entry to include. If smaller than endTimestamp, sort order is inverted.")
    @DefaultValue(value="9223372036854775807")
    private long endTimestamp;
    @JsonProperty(value="oldestTimestamp")
    @QueryParam(value="oldestTimestamp")
    @Parameter(description="The timestamp of the oldest log entry that will be displayed. This is necessary to determine display of collapsed log entries.")
    @DefaultValue(value="0")
    private long oldestTimestamp;
    @JsonProperty(value="filterRegex")
    @QueryParam(value="filterRegex")
    @Parameter(description="Optional regular expression used for filtering log entries.")
    private String filterRegex;
    @JsonProperty(value="includeMatches")
    @QueryParam(value="includeMatches")
    @Parameter(description="Whether to include or exclude matches of the filterRegex.")
    @DefaultValue(value="true")
    private boolean includeMatches;
    @JsonProperty(value="searchDetailedLogs")
    @QueryParam(value="searchDetailedLogs")
    @Parameter(description="Whether to search detailed log messages (may be expensive)")
    @DefaultValue(value="false")
    private boolean searchDetailedLogs;
    @JsonProperty(value="collapseRepeatedEntries")
    @QueryParam(value="collapseRepeatedEntries")
    @Parameter(description="Whether to collapse repeated entries")
    @DefaultValue(value="false")
    private boolean collapseRepeatedEntries;

    public LogFilteringParameters() {
    }

    public LogFilteringParameters(ELogLevel minLogLevel, int maxResults, long startTimestamp, long endTimestamp, long oldestTimestamp, String filterRegex, boolean includeMatches, boolean searchDetailedLogs, boolean collapseRepeatedEntries) {
        this.minLogLevel = minLogLevel;
        this.maxResults = maxResults;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.oldestTimestamp = oldestTimestamp;
        this.filterRegex = filterRegex;
        this.includeMatches = includeMatches;
        this.searchDetailedLogs = searchDetailedLogs;
        this.collapseRepeatedEntries = collapseRepeatedEntries;
    }

    public ELogLevel getMinLogLevel() {
        return this.minLogLevel;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public long getOldestTimestamp() {
        return this.oldestTimestamp;
    }

    public String getFilterRegex() {
        return this.filterRegex;
    }

    public boolean isIncludeMatches() {
        return this.includeMatches;
    }

    public boolean isSearchDetailedLogs() {
        return this.searchDetailedLogs;
    }

    public boolean isCollapseRepeatedEntries() {
        return this.collapseRepeatedEntries;
    }
}

