/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.logging;

import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.core.log.worker.WorkerLogDigestIndexBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class LogIndexesWrapper<SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EnumSet<ELogLevel> SUPPORTED_LOG_LEVELS = EnumSet.of(ELogLevel.INFO, ELogLevel.ERROR, ELogLevel.WARN, ELogLevel.FATAL, ELogLevel.DEBUG);
    private final PairList<PublicProjectId, LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY>> delegates;
    private final Map<PublicProjectId, WorkerLogDigestIndexBase> digestIndexes;

    public LogIndexesWrapper(PairList<PublicProjectId, LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY>> logIndexes) {
        this(logIndexes, Collections.emptyMap());
    }

    public LogIndexesWrapper(PairList<PublicProjectId, LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY>> logIndexes, Map<PublicProjectId, WorkerLogDigestIndexBase> digestIndexes) {
        this.delegates = logIndexes;
        this.digestIndexes = digestIndexes;
    }

    public List<SHORT_LOG_ENTRY> getEntries(ELogLevel minLogLevel, long startTimestamp, long endTimestamp, boolean newestEntriesFirst) throws StorageException {
        ArrayList<SHORT_LOG_ENTRY> result = new ArrayList<SHORT_LOG_ENTRY>();
        for (Pair next : this.getAllProjectsAndIndexes()) {
            result.addAll(this.getEntries(next, minLogLevel, startTimestamp, endTimestamp));
        }
        Comparator entryComparator = Comparator.naturalOrder();
        if (newestEntriesFirst) {
            entryComparator = entryComparator.reversed();
        }
        return CollectionUtils.sort(result, entryComparator);
    }

    private List<SHORT_LOG_ENTRY> getEntries(Pair<PublicProjectId, LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY>> indexWithProjectId, ELogLevel minLogLevel, long startTimestamp, long endTimestamp) throws StorageException {
        if (!SUPPORTED_LOG_LEVELS.contains(minLogLevel)) {
            throw new IllegalArgumentException("Unsupported value for minimum log level");
        }
        PublicProjectId projectId = (PublicProjectId)indexWithProjectId.getFirst();
        LogIndexBase index = (LogIndexBase)indexWithProjectId.getSecond();
        ArrayList result = new ArrayList();
        switch (minLogLevel) {
            case DEBUG: {
                result.addAll(index.getEntries(LogIndexBase.EIndexLogLevel.DEBUG, startTimestamp, endTimestamp));
            }
            case INFO: {
                result.addAll(index.getEntries(LogIndexBase.EIndexLogLevel.INFO, startTimestamp, endTimestamp));
            }
            case WARN: {
                result.addAll(index.getEntries(LogIndexBase.EIndexLogLevel.WARN, startTimestamp, endTimestamp));
            }
            case ERROR: {
                result.addAll(index.getEntries(LogIndexBase.EIndexLogLevel.ERROR, startTimestamp, endTimestamp));
            }
            case FATAL: {
                result.addAll(index.getEntries(LogIndexBase.EIndexLogLevel.FATAL, startTimestamp, endTimestamp));
            }
        }
        for (ShortLogEntryBase entry : result) {
            entry.setProjectId(projectId);
        }
        return result;
    }

    public DETAILED_LOG_ENTRY getDetailedLog(LogEntryIdentifier logEntryIdentifier) throws StorageException {
        for (LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> next : this.getAllIndexes()) {
            DetailedLogEntryBase detailedLog = next.getDetailedLog(logEntryIdentifier);
            if (detailedLog == null) continue;
            return (DETAILED_LOG_ENTRY)detailedLog;
        }
        return null;
    }

    public List<SHORT_LOG_ENTRY> getCollapsedEntries(ELogLevel minLogLevel, long startTimestamp, long endTimestamp, long oldestTimestamp, boolean newestEntriesFirst) throws StorageException {
        ArrayList<Object> result = new ArrayList<Object>();
        Comparator entryComparator = Comparator.naturalOrder();
        if (newestEntriesFirst) {
            entryComparator = entryComparator.reversed();
        }
        for (Pair next : this.getAllProjectsAndIndexes()) {
            List<SHORT_LOG_ENTRY> entries = this.getEntries(next, minLogLevel, startTimestamp, endTimestamp);
            if (CollectionUtils.isNullOrEmpty(entries)) continue;
            if (entries.get(0) instanceof ShortWorkerLog) {
                List sortedEntries = CollectionUtils.sort(entries, entryComparator);
                result.addAll(LogIndexesWrapper.collapseWorkerLogs(this.digestIndexes.get(next.getFirst()), sortedEntries, oldestTimestamp));
                continue;
            }
            result.addAll(entries);
        }
        return CollectionUtils.sort(result, entryComparator);
    }

    private static List<? extends ShortWorkerLog> collapseWorkerLogs(WorkerLogDigestIndexBase digestIndex, List<ShortWorkerLog> shortLogs, long oldestTimestamp) throws StorageException {
        if (digestIndex == null) {
            LOGGER.error("Empty digest index given");
            return shortLogs;
        }
        ListMap occurrencesMap = digestIndex.getOccurrences(shortLogs);
        HashSet timestampsToSkip = new HashSet();
        return CollectionUtils.filter(shortLogs, log -> {
            long timestamp = log.getTimestamp();
            if (timestampsToSkip.contains(timestamp)) {
                return false;
            }
            if (!occurrencesMap.containsCollection((Object)timestamp)) {
                return true;
            }
            List occurrences = (List)occurrencesMap.getCollection((Object)timestamp);
            Optional<Long> oldestTimestampToDisplay = occurrences.stream().filter(occurrence -> occurrence >= oldestTimestamp).findFirst();
            timestampsToSkip.addAll(occurrences);
            boolean shouldDisplayLogEntry = oldestTimestampToDisplay.map(occurrence -> occurrence == timestamp).orElse(false);
            if (shouldDisplayLogEntry) {
                log.setOccurrences(occurrences);
            } else {
                oldestTimestampToDisplay.ifPresent(timestampsToSkip::remove);
            }
            return shouldDisplayLogEntry;
        });
    }

    public void deleteLogEntries(List<SHORT_LOG_ENTRY> entriesToDelete) throws StorageException {
        ArrayList<byte[]> keysToDelete = new ArrayList<byte[]>();
        for (ShortLogEntryBase shortLogEntryBase : entriesToDelete) {
            LogIndexBase.EIndexLogLevel level = shortLogEntryBase.getIndexLogLevel();
            byte[] keyToDelete = LogIndexBase.makeTimestampKey((LogIndexBase.EIndexLogLevel)level, (LogEntryIdentifier)shortLogEntryBase.getId());
            keysToDelete.add(keyToDelete);
        }
        for (LogIndexBase logIndexBase : this.getAllIndexes()) {
            logIndexBase.delete(keysToDelete);
        }
    }

    public List<LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY>> getAllIndexes() {
        return this.delegates.extractSecondList();
    }

    public PairList<PublicProjectId, LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY>> getAllProjectsAndIndexes() {
        return this.delegates;
    }

    public boolean haveLogsBeenTruncated() throws StorageException {
        for (LogIndexBase<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> index : this.getAllIndexes()) {
            if (!index.hasBeenTruncated()) continue;
            return true;
        }
        return false;
    }
}

