/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai.i9d;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.ai.LlmPrompt;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.Retrofit;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.POST;
import retrofit2.http.Path;

public class I9DAiClient
implements ILlmCompleter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String baseUrl;
    private final String model;
    private final String accessToken;
    private final double temperature;

    public I9DAiClient(String baseUrl, String model, String accessToken, double temperature) {
        this.baseUrl = baseUrl;
        this.model = model;
        this.accessToken = accessToken;
        this.temperature = temperature;
    }

    private static @NonNull List<I9DDataPart> buildPromptParts(LlmPrompt prompt) {
        ArrayList<I9DDataPart> parts = new ArrayList<I9DDataPart>();
        parts.add(new I9DTextDataPart(prompt.text()));
        parts.addAll(CollectionUtils.map(prompt.attachments(), attachment -> new I9DInlineDataPart(new I9DInlineData(Base64.getEncoder().encodeToString(attachment.getBytes(StandardCharsets.UTF_8)), "text/plain"))));
        return parts;
    }

    @Override
    public String complete(LlmPrompt prompt) throws ServiceCallException {
        I9DAiService i9d = (I9DAiService)Retrofit.builder((String)this.baseUrl).withInteractionLogger(LOGGER).withBearerAuthentication(this.accessToken).create(I9DAiService.class);
        I9DConfig config = new I9DConfig(this.temperature);
        List<I9DDataPart> parts = I9DAiClient.buildPromptParts(prompt);
        I9DPromptContent content = new I9DPromptContent("user", parts);
        I9DPredictResponse response = (I9DPredictResponse)Retrofit.executeServiceCall(i9d.performPrediction(this.model, new I9DPredictRequest(List.of(content), config))).orElseThrow(() -> new ServiceCallException("No response returned from LLM!"));
        StringBuilder result = new StringBuilder();
        if (response.candidates() != null && response.candidates().getFirst().content() != null) {
            response.candidates().getFirst().content().parts().forEach(part -> result.append(part.text()));
        }
        return result.toString();
    }

    private record I9DTextDataPart(String text) implements I9DDataPart
    {
    }

    private static interface I9DAiService
    extends IRetrofitApi {
        @POST(value="v1beta/models/{model}:generateContent")
        public Call<I9DPredictResponse> performPrediction(@Path(value="model") String var1, @Body I9DPredictRequest var2);
    }

    private record I9DConfig(double temperature) {
    }

    private record I9DPromptContent(String role, List<I9DDataPart> parts) {
    }

    private record I9DPredictRequest(List<I9DPromptContent> contents, @JsonProperty(value="generation_config") I9DConfig generationConfig) {
    }

    private record I9DPredictResponse(List<I9DCandidate> candidates) {
    }

    private record I9DCandidate(I9DResponseContent content) {
    }

    private record I9DResponseContent(String role, List<I9DPart> parts) {
    }

    private record I9DPart(String text) {
    }

    private record I9DInlineDataPart(@JsonProperty(value="inline_data") I9DInlineData inlineData) implements I9DDataPart
    {
    }

    private record I9DInlineData(String data, @JsonProperty(value="mime_type") String mimeType) {
    }

    private static interface I9DDataPart {
    }
}

