/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.KeyDelta;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public sealed class IndexDelta<T extends Serializable>
implements IIndexDelta
permits KeyDelta {
    private static final long serialVersionUID = 1L;
    private final UnmodifiableList<T> addedOrChanged;
    private final UnmodifiableList<T> deleted;
    private final transient @Nullable Comparator<T> comparator;

    public IndexDelta(Collection<? extends T> addedOrChanged, Collection<? extends T> deleted) {
        this(addedOrChanged, deleted, null);
    }

    public IndexDelta(Collection<? extends T> addedOrChanged, Collection<? extends T> deleted, @Nullable Comparator<? super T> comparator) {
        this.addedOrChanged = IndexDelta.sorted(addedOrChanged, comparator);
        this.deleted = IndexDelta.sorted(deleted, comparator);
        this.comparator = comparator;
    }

    public static <T extends Serializable> IndexDelta<T> empty() {
        return new IndexDelta(Collections.emptyList(), Collections.emptyList());
    }

    private static <T> UnmodifiableList<T> sorted(Collection<? extends T> deltaEntries, @Nullable Comparator<? super T> comparator) {
        ArrayList<T> result = new ArrayList<T>(deltaEntries);
        if (comparator != null) {
            result.sort(comparator);
        }
        return CollectionUtils.asUnmodifiable(result);
    }

    public UnmodifiableList<T> getAddedOrChangedKeys() {
        return this.addedOrChanged;
    }

    public UnmodifiableList<T> getDeletedKeys() {
        return this.deleted;
    }

    @Override
    public boolean isEmpty() {
        return this.addedOrChanged.isEmpty() && this.deleted.isEmpty();
    }

    @Override
    public int size() {
        return this.addedOrChanged.size() + this.deleted.size();
    }

    public List<? extends IndexDelta<T>> split(int maxDeltaSize) {
        if (this.size() <= maxDeltaSize) {
            return Collections.singletonList(this);
        }
        ArrayList result = new ArrayList();
        if (!this.addedOrChanged.isEmpty()) {
            for (Collection sublist : Lists.partition(this.addedOrChanged, (int)maxDeltaSize)) {
                result.add(this.createNewInstance(sublist, Collections.emptyList()));
            }
        }
        if (!this.deleted.isEmpty()) {
            for (Collection sublist : Lists.partition(this.deleted, (int)maxDeltaSize)) {
                result.add(this.createNewInstance(Collections.emptyList(), sublist));
            }
        }
        return result;
    }

    @Override
    public IndexDelta<T> combine(IIndexDelta delta) {
        if (!this.getClass().equals(delta.getClass())) {
            throw new IllegalArgumentException("Expected delta of type %s but was %s".formatted(this.getClass(), delta.getClass()));
        }
        HashSet<T> addedOrChanged = new HashSet<T>(this.addedOrChanged);
        HashSet<T> deleted = new HashSet<T>(this.deleted);
        IndexDelta typedDelta = (IndexDelta)delta;
        addedOrChanged.addAll((Collection<T>)typedDelta.addedOrChanged);
        deleted.addAll((Collection<T>)typedDelta.deleted);
        deleted.removeAll(addedOrChanged);
        return this.createNewInstance(addedOrChanged, deleted);
    }

    @Override
    public IndexDelta<String> asLogDelta() {
        return this.map(String::valueOf, null);
    }

    public <S extends Serializable> IndexDelta<S> map(Function<? super T, ? extends S> mapper, @Nullable Comparator<? super S> comparator) {
        return new IndexDelta<S>(this.addedOrChanged.stream().map(mapper).toList(), this.deleted.stream().map(mapper).toList(), comparator);
    }

    private IndexDelta<T> createNewInstance(Collection<T> addedOrChanged, Collection<T> deleted) {
        IndexDelta<T> result = this.create(addedOrChanged, deleted, this.comparator);
        CCSMAssert.isTrue((boolean)this.getClass().equals(result.getClass()), () -> "'create' did not return an instance of this class %s, but of %s".formatted(this.getClass(), result.getClass()));
        return result;
    }

    protected IndexDelta<T> create(Collection<T> addedOrChanged, Collection<T> deleted, @Nullable Comparator<T> comparator) {
        return new IndexDelta<T>(addedOrChanged, deleted, comparator);
    }

    public String toString() {
        return "added/changed: " + String.valueOf(this.addedOrChanged) + ", deleted: " + String.valueOf(this.deleted);
    }
}

