/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.analysis.configuration.JsonNodeTriggerParameter;
import java.util.Objects;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.test.NoIndexValueClass;

@NoIndexValueClass(rationale="Trigger parameters are not stored directly.\nInstead, this will be serialized to JSON and then stored.\nOf course, implementing classes may still be stored in a different index.\n")
public interface ITriggerParameter {
    @JsonIgnore
    default public JsonNode toJson() {
        return JsonUtils.getObjectMapper().valueToTree((Object)this);
    }

    public static ITriggerParameter of(String value) {
        Objects.requireNonNull(value, "value");
        return new JsonNodeTriggerParameter((JsonNode)JsonUtils.getObjectMapper().getNodeFactory().textNode(value));
    }

    public static ITriggerParameter of(boolean value) {
        return new JsonNodeTriggerParameter((JsonNode)JsonUtils.getObjectMapper().getNodeFactory().booleanNode(value));
    }

    public static ITriggerParameter of(int value) {
        return new JsonNodeTriggerParameter((JsonNode)JsonUtils.getObjectMapper().getNodeFactory().numberNode(value));
    }

    public static ITriggerParameter of(long value) {
        return new JsonNodeTriggerParameter((JsonNode)JsonUtils.getObjectMapper().getNodeFactory().numberNode(value));
    }

    public static ITriggerParameter of(Object value) {
        Objects.requireNonNull(value, "value");
        if (value instanceof ITriggerParameter) {
            ITriggerParameter triggerParameter = (ITriggerParameter)value;
            return triggerParameter;
        }
        return new JsonNodeTriggerParameter(JsonUtils.getObjectMapper().valueToTree(value));
    }
}

