/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.CodeScopedAnalysisConfigurationValidator;
import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplateManager;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationHooks;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.ProjectDefaultBranchUtils;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectBranchingConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.BooleanOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ProjectCreator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ConsumerWithException<ProjectConfiguration, ProjectConfigurationException>> CREATION_LISTENERS = new ArrayList<ConsumerWithException<ProjectConfiguration, ProjectConfigurationException>>();
    private final IndexLayer indexLayer;
    private final @Nullable String username;
    private final ConfigurationInitializationContext.EInitializationReason initializationReason;
    private ConfigurationTemplateManager templateManager;
    private final CodeScopeAware<AnalysisProfile> profiles = CodeScopeAware.empty();
    private ProjectCreationProxy proxy;
    private final Set<ConfigurationItemBase> adjustedConfigurationItems = new IdentityHashSet();

    public ProjectCreator(IndexLayer indexLayer, @Nullable String username, ConfigurationInitializationContext.EInitializationReason initializationReason) {
        this.indexLayer = indexLayer;
        this.username = username;
        this.initializationReason = initializationReason;
    }

    public ProjectCreator(IndexLayer indexLayer, ConfigurationInitializationContext.EInitializationReason initializationReason) {
        this(indexLayer, null, initializationReason);
    }

    public void createProject(ProjectConfiguration projectConfiguration) throws TriggerCompilationException, StorageException, ProjectConfigurationException {
        this.createProject(projectConfiguration, true);
    }

    public void createProject(ProjectConfiguration projectConfiguration, boolean validateTools) throws TriggerCompilationException, StorageException, ProjectConfigurationException {
        this.createProject(projectConfiguration, true, true, validateTools);
    }

    public void createProject(ProjectConfiguration projectConfiguration, boolean validateProject, boolean reloadTriggers, boolean validateTools) throws TriggerCompilationException, StorageException, ProjectConfigurationException {
        this.createOrUpdateProject(projectConfiguration, false, validateProject, reloadTriggers, false, validateTools);
    }

    private void createOrUpdateProject(ProjectConfiguration projectConfiguration, boolean assumeExisting, boolean validateProject, boolean reloadTriggers, boolean forceEmbeddedProfile, boolean validateTools) throws TriggerCompilationException, StorageException, ProjectConfigurationException {
        boolean parentProjectCanBeResolved = true;
        if (!assumeExisting) {
            ProjectConfigurationUtils.checkProjectNameAndIds(this.indexLayer, projectConfiguration);
            parentProjectCanBeResolved = ProjectConfigurationUtils.parentProjectCanBeResolved(this.indexLayer, projectConfiguration, validateProject);
        }
        GlobalStorageSystem globalStorageSystem = this.indexLayer.openGlobalStorageSystem();
        InternalProjectId internalId = projectConfiguration.getInternalId();
        this.proxy = this.getProjectCreationProxy(projectConfiguration, assumeExisting, forceEmbeddedProfile, internalId, globalStorageSystem);
        ProjectCreator.notifyCreationListeners(projectConfiguration);
        ConfigurationInitializationContext configurationInitializationContext = new ConfigurationInitializationContext(this.username, this.indexLayer, this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class), this.initializationReason);
        List<ConnectorDescriptorBase> connectors = this.createConnectors((List<ConnectorConfiguration>)projectConfiguration.getConnectors(), configurationInitializationContext, projectConfiguration, validateProject);
        this.createAnalyses(validateTools);
        this.applyQualityIndicatorOptions();
        new CodeScopedAnalysisConfigurationValidator(this.templateManager.getConfigurationTemplatePerCodeScope(), this.profiles).validate();
        ProjectConfigurationHooks.getInstance().configure(this.proxy, configurationInitializationContext, validateProject);
        this.proxy.checkConsistency((SchemaAwareStorageSystem)globalStorageSystem);
        boolean wasNotYetPaused = ProjectSchedulingFilter.pauseProject(internalId, globalStorageSystem);
        boolean areAllConnectorsConfigured = ProjectCreator.areAllConnectorsConfigured(connectors);
        this.proxy.createProject(this.indexLayer, assumeExisting, parentProjectCanBeResolved && areAllConnectorsConfigured);
        this.profiles.getCodeScopeNames().forEach(codeScopeName -> projectConfiguration.setEmbeddedProfile(this.profiles.getValue((CodeScopeName)codeScopeName), (CodeScopeName)codeScopeName));
        this.writeProjectConfiguration(projectConfiguration.withInternalParentId(this.indexLayer));
        if (areAllConnectorsConfigured) {
            this.storeConnectorConfigs(validateProject, internalId, connectors);
        }
        String projectDefaultBranch = ProjectDefaultBranchUtils.determineProjectDefaultBranch(connectors);
        ProjectDefaultBranchUtils.setProjectDefaultBranch(this.indexLayer, validateProject, projectDefaultBranch, internalId);
        if (validateProject) {
            projectConfiguration.validate(this.indexLayer, this.username, !StringUtils.isEmpty((String)projectConfiguration.getExternalStorageBackend()));
        }
        if (reloadTriggers) {
            this.reloadTriggers();
        }
        if (wasNotYetPaused) {
            ProjectSchedulingFilter.resumeProjectIfPaused(internalId, globalStorageSystem);
        }
    }

    private static boolean areAllConnectorsConfigured(List<ConnectorDescriptorBase> connectors) {
        List<ConnectorDescriptorBase> nonConfiguredConnectors = connectors.stream().filter(config -> !config.isConfigured()).toList();
        if (!nonConfiguredConnectors.isEmpty()) {
            LOGGER.warn("Can not store configuration data of unconfigured connectors {}. This is likely the case because the connector did not validate and thus could not be initialized.", nonConfiguredConnectors.stream().map(ConnectorDescriptorBase::getName).toList());
            return false;
        }
        return true;
    }

    private @NonNull ProjectCreationProxy getProjectCreationProxy(ProjectConfiguration projectConfiguration, boolean assumeExisting, boolean forceEmbeddedProfile, InternalProjectId internalId, GlobalStorageSystem globalStorageSystem) throws StorageException, ProjectConfigurationException {
        List<AnalysisTrigger> previousTriggers = null;
        ProjectConfiguration previousConfiguration = null;
        ProjectBranchingConfiguration previousBranchingConfiguration = null;
        if (assumeExisting) {
            CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)internalId);
            previousConfiguration = ProjectConfigurationUtils.getProjectConfiguration(projectStorageSystem);
            previousBranchingConfiguration = ProjectConfigurationUtils.loadPreviousBranchingConfiguration(projectStorageSystem);
            previousTriggers = ProjectConfigurationUtils.loadPreviousTriggers(globalStorageSystem, projectStorageSystem);
        }
        ProjectCreator.setBranchingConfigurationStartTimestamps(projectConfiguration, previousBranchingConfiguration);
        this.setProfiles(projectConfiguration, forceEmbeddedProfile);
        this.templateManager = ConfigRegistry.getInstance().initializeConfigurationTemplateManager(this.getLanguagesPerCodeScope(), this.getToolsPerCodeScope(), this.profiles.getCodeScopeNames(), globalStorageSystem);
        InternalProjectId parentProjectId = null;
        if (projectConfiguration.getParentProjectId() != null) {
            parentProjectId = this.indexLayer.resolveToInternalProjectId(projectConfiguration.getParentProjectId());
        }
        return new ProjectCreationProxy(internalId, projectConfiguration.getExternalStorageProjectMappingId(), parentProjectId, this.getLanguagesPerCodeScope(), projectConfiguration, previousConfiguration, previousTriggers, projectConfiguration.getCodeScopes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyCreationListeners(ProjectConfiguration projectConfiguration) throws ProjectConfigurationException {
        List<ConsumerWithException<ProjectConfiguration, ProjectConfigurationException>> list = CREATION_LISTENERS;
        synchronized (list) {
            for (ConsumerWithException<ProjectConfiguration, ProjectConfigurationException> creationListener : CREATION_LISTENERS) {
                creationListener.accept((Object)projectConfiguration);
            }
        }
    }

    private void storeConnectorConfigs(boolean validateProject, InternalProjectId internalId, List<ConnectorDescriptorBase> connectors) throws StorageException, ProjectConfigurationException {
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)internalId);
        for (ConnectorDescriptorBase connector : connectors) {
            try {
                connector.storeConfigurationData(projectStorageSystem);
            }
            catch (ProjectConfigurationException e) {
                ProjectCreator.rethrowIfValidationIsEnabled(validateProject, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCreationListener(ConsumerWithException<ProjectConfiguration, ProjectConfigurationException> creationListener) {
        List<ConsumerWithException<ProjectConfiguration, ProjectConfigurationException>> list = CREATION_LISTENERS;
        synchronized (list) {
            CREATION_LISTENERS.add(creationListener);
        }
    }

    private static void setBranchingConfigurationStartTimestamps(ProjectConfiguration projectConfiguration, ProjectBranchingConfiguration previousBranchingConfiguration) throws ProjectConfigurationException {
        if (projectConfiguration.getBranchingConfiguration() == null) {
            return;
        }
        if (previousBranchingConfiguration != null && previousBranchingConfiguration.equals(projectConfiguration.getBranchingConfiguration())) {
            projectConfiguration.setBranchingConfiguration(previousBranchingConfiguration);
        } else {
            projectConfiguration.getBranchingConfiguration().storeStartDatesAsTimestamp();
        }
    }

    public void refreshProject(ProjectConfiguration projectConfiguration, boolean validateProject, boolean reloadTriggers, boolean forceEmbeddedProfile, boolean validateTools) throws StorageException, ProjectConfigurationException, TriggerCompilationException {
        this.createOrUpdateProject(projectConfiguration, true, validateProject, reloadTriggers, forceEmbeddedProfile, validateTools);
    }

    private void reloadTriggers() {
        ISchedulerCommunicator.getInstance().sendReloadCommand(this.indexLayer.getMessageBroker(), this.proxy.getInternalId());
    }

    private List<ConnectorDescriptorBase> createConnectors(List<ConnectorConfiguration> connectors, ConfigurationInitializationContext context, ProjectConfiguration projectConfiguration, boolean validateProject) throws ProjectConfigurationException {
        ArrayList<ConnectorDescriptorBase> result = new ArrayList<ConnectorDescriptorBase>();
        HashSet<String> identifiers = new HashSet<String>();
        for (int i = 0; i < connectors.size(); ++i) {
            ConnectorConfiguration connector = connectors.get(i);
            String identifier = connector.getIdentifier();
            if (identifier != null && !identifiers.add(identifier)) {
                throw new ProjectConfigurationException("Duplicate identifier in connectors: " + identifier);
            }
            ConnectorDescriptorBase connectorDescriptor = this.createConnector(connector, context, projectConfiguration.getInternalId(), validateProject, i);
            result.add(connectorDescriptor);
        }
        return result;
    }

    private ConnectorDescriptorBase createConnector(ConnectorConfiguration connector, ConfigurationInitializationContext context, InternalProjectId internalId, boolean validateProject, int connectorIndex) throws ProjectConfigurationException {
        ConnectorDescriptorBase connectorDescriptor = ConnectorUtils.loadConnector(connector, context, internalId);
        try {
            if (validateProject) {
                ConnectorUtils.validateConnector(connectorDescriptor, connectorIndex);
            }
            connectorDescriptor.configureProjectInternal(this.proxy);
        }
        catch (ProjectConfigurationException e) {
            ProjectCreator.rethrowIfValidationIsEnabled(validateProject, e);
        }
        return connectorDescriptor;
    }

    private static void rethrowIfValidationIsEnabled(boolean validateProject, ProjectConfigurationException e) throws ProjectConfigurationException {
        if (validateProject) {
            throw e;
        }
        LOGGER.warn("Ignored validation error during project import. This may result in follow-up errors.", (Throwable)e);
    }

    private void createAnalyses(boolean validateTools) throws ProjectConfigurationException {
        IdentityHashSet selectedConfigurations = new IdentityHashSet();
        for (CodeScopeName codeScopeName : this.profiles.getCodeScopeNames()) {
            this.applyGlobalOptions((Set<AnalysisConfigurationBase>)selectedConfigurations, codeScopeName);
            this.applyQualityIndicators((Set<AnalysisConfigurationBase>)selectedConfigurations, codeScopeName);
        }
        List<AnalysisConfigurationBase> executedConfigurations = this.templateManager.getExecutedConfigurations((Set<AnalysisConfigurationBase>)selectedConfigurations);
        for (AnalysisConfigurationBase configuration : executedConfigurations) {
            this.disableUnchangedConfigItems(configuration);
            configuration.configureProject(this.proxy);
            if (!validateTools || !(configuration instanceof ToolConfigurationBase)) continue;
            ((ToolConfigurationBase)configuration).validateTools();
        }
    }

    private void disableUnchangedConfigItems(AnalysisConfigurationBase configuration) throws ProjectConfigurationException {
        for (CodeScopeName codeScopeName : this.profiles.getCodeScopeNames()) {
            for (ConfigOptionDescriptorBase option : configuration.getVisibleOptions()) {
                if (!(option instanceof BooleanOptionDescriptor) || this.adjustedConfigurationItems.contains(option)) continue;
                option.setValue(Boolean.toString(false), codeScopeName);
            }
            for (MetricDescriptor metric : configuration.getProvidedMetrics(codeScopeName)) {
                if (this.adjustedConfigurationItems.contains(metric)) continue;
                metric.setValue(Boolean.toString(false), codeScopeName);
            }
            for (FindingDescriptor finding : configuration.getProvidedFindings(codeScopeName)) {
                if (this.adjustedConfigurationItems.contains(finding)) continue;
                finding.setValue(EFindingEnablement.OFF.name(), codeScopeName);
            }
        }
    }

    private void applyGlobalOptions(Set<AnalysisConfigurationBase> selectedConfigurations, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        AnalysisProfile profile = this.profiles.getValue(codeScopeName);
        for (String optionName : profile.getOptionNames()) {
            ConfigOptionDescriptorBase globalOption = this.templateManager.getGlobalOption(optionName, codeScopeName);
            if (globalOption == null) {
                throw new ProjectConfigurationException("Unknown global option " + optionName + ". Current state of the configuration template: " + ToStringBuilder.reflectionToString((Object)this.templateManager.getConfigurationTemplate(codeScopeName), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
            }
            this.adjustedConfigurationItems.add(globalOption);
            globalOption.setValue(profile.getOptionValue(optionName), codeScopeName);
            CCSMAssert.isInstanceOf((Object)globalOption.getConfiguration(), AnalysisConfigurationBase.class);
            selectedConfigurations.add((AnalysisConfigurationBase)globalOption.getConfiguration());
        }
    }

    private void applyQualityIndicators(Set<AnalysisConfigurationBase> selectedConfigurations, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        for (QualityIndicator indicator : this.profiles.getValue(codeScopeName).getQualityIndicators()) {
            if (indicator.getGroups().isEmpty()) continue;
            this.addQualityIndicator(indicator, selectedConfigurations, codeScopeName);
        }
    }

    private void addQualityIndicator(QualityIndicator indicator, Set<AnalysisConfigurationBase> selectedConfigurations, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        for (AnalysisGroup group : indicator.getGroups()) {
            if (group.getOptionNames().isEmpty()) continue;
            AnalysisGroupDescriptor groupDescriptor = this.templateManager.getAnalysisGroup(group.getName(), codeScopeName);
            try {
                this.addGroup(group, groupDescriptor, indicator, selectedConfigurations, codeScopeName);
            }
            catch (ProjectConfigurationException e) {
                throw new ProjectConfigurationException("Configuration error in analysis group '" + group.getName() + "': " + e.getMessage(), e);
            }
        }
    }

    private void addGroup(AnalysisGroup group, AnalysisGroupDescriptor groupDescriptor, QualityIndicator indicator, Set<AnalysisConfigurationBase> selectedConfigurations, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        if (groupDescriptor == null) {
            throw new ProjectConfigurationException("Unknown fragment " + group.getName() + " for indicator " + indicator.getName());
        }
        for (String optionName : group.getOptionNames()) {
            ConfigurationItemBase configItem = groupDescriptor.getConfigurationItem(optionName);
            if (configItem == null) {
                throw new ProjectConfigurationException("Unknown configuration item '" + optionName + "' for group '" + group.getName() + "' in indicator " + indicator.getName());
            }
            if (configItem instanceof FindingDescriptor) {
                FindingDescriptor findingDescriptor = (FindingDescriptor)configItem;
                findingDescriptor.setMappedCategoryAndGroup(indicator.getName(), group.getName());
                this.adjustedConfigurationItems.addAll((Collection<ConfigurationItemBase>)findingDescriptor.getReferencedOptions());
            }
            this.adjustedConfigurationItems.add(configItem);
            configItem.setValue(group.getOptionValue(optionName), codeScopeName);
        }
        selectedConfigurations.addAll(groupDescriptor.getReferencedConfigurations((Set<EAnalysisTool>)this.profiles.getValue(codeScopeName).getTools()));
    }

    private void applyQualityIndicatorOptions() throws ProjectConfigurationException {
        for (CodeScopeName codeScopeName : this.profiles.getCodeScopeNames()) {
            for (QualityIndicator indicator : this.profiles.getValue(codeScopeName).getQualityIndicators()) {
                this.applyQualityIndicatorOptions(indicator, codeScopeName);
            }
        }
    }

    private void applyQualityIndicatorOptions(QualityIndicator indicator, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        IdentityHashSet changedIndicatorOptions = new IdentityHashSet();
        IdentityHashSet selectedConfigurations = new IdentityHashSet();
        this.setQualityIndicatorOptions(indicator, (Set<ConfigOptionDescriptorBase>)changedIndicatorOptions, (Set<AnalysisConfigurationBase>)selectedConfigurations, codeScopeName);
        if (selectedConfigurations.isEmpty()) {
            return;
        }
        List<AnalysisConfigurationBase> executedConfigurations = this.templateManager.getExecutedConfigurations((Set<AnalysisConfigurationBase>)selectedConfigurations);
        ProjectCreator.disableUnchangedQualityIndicatorOptions((Set<ConfigOptionDescriptorBase>)changedIndicatorOptions, executedConfigurations, codeScopeName);
        for (AnalysisConfigurationBase configuration : executedConfigurations) {
            configuration.applyQualityIndicatorOptions(indicator.getName(), this.proxy);
        }
    }

    private void setQualityIndicatorOptions(QualityIndicator indicator, Set<ConfigOptionDescriptorBase> changedIndicatorOptions, Set<AnalysisConfigurationBase> selectedConfigurations, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        for (String optionName : indicator.getOptionNames()) {
            ConfigOptionDescriptorBase option = this.templateManager.getQualityIndicatorOption(optionName, codeScopeName);
            if (option == null) {
                throw new ProjectConfigurationException("Unknown quality indicator option '" + optionName + "' in indicator " + indicator.getName());
            }
            changedIndicatorOptions.add(option);
            option.setValue(indicator.getOptionValue(optionName), codeScopeName);
            selectedConfigurations.add((AnalysisConfigurationBase)option.getConfiguration());
        }
    }

    private static void disableUnchangedQualityIndicatorOptions(Set<ConfigOptionDescriptorBase> changedIndicatorOptions, List<AnalysisConfigurationBase> executedConfigurations, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        for (AnalysisConfigurationBase configuration : executedConfigurations) {
            for (ConfigOptionDescriptorBase option : configuration.getVisibleOptions()) {
                if (!(option instanceof BooleanOptionDescriptor) || changedIndicatorOptions.contains(option)) continue;
                option.setValue(Boolean.toString(false), codeScopeName);
            }
        }
    }

    private void writeProjectConfiguration(ProjectConfiguration projectConfiguration) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)projectConfiguration.getInternalId());
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        projectMetaIndex.setValue((MetaIndex.IMetaIndexEntry)projectConfiguration, ProjectConfiguration.class);
        projectMetaIndex.setValue((MetaIndex.IMetaIndexEntry)projectConfiguration.getBranchingConfiguration(), ProjectBranchingConfiguration.class);
    }

    private CodeScopeAware<Set<ELanguage>> getLanguagesPerCodeScope() {
        CodeScopeAware<Set<ELanguage>> languages = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : this.profiles.getCodeScopeNames()) {
            languages.setValue(codeScopeName, (Set<ELanguage>)this.profiles.getValue(codeScopeName).getLanguages());
        }
        return languages;
    }

    private CodeScopeAware<Set<EAnalysisTool>> getToolsPerCodeScope() {
        CodeScopeAware<Set<EAnalysisTool>> toolsPerCodeScope = CodeScopeAware.empty();
        this.profiles.forEach(profileForScope -> toolsPerCodeScope.setValue((CodeScopeName)profileForScope.getKey(), (Set<EAnalysisTool>)((AnalysisProfile)profileForScope.getValue()).getTools()));
        return toolsPerCodeScope;
    }

    private void setProfiles(ProjectConfiguration projectConfiguration, boolean forceEmbeddedProfile) throws StorageException, ProjectConfigurationException {
        for (CodeScope codeScope : projectConfiguration.getCodeScopes()) {
            if (forceEmbeddedProfile) {
                this.profiles.setValue(codeScope.getName(), codeScope.getEmbeddedProfile());
                continue;
            }
            this.profiles.setValue(codeScope.getName(), ProjectConfigurationUtils.determineAnalysisProfile(this.indexLayer, projectConfiguration, codeScope.getName()));
        }
    }
}

