/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.connectors.ICommitTreeConnectorDescriptor;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ProjectDefaultBranchUtils {
    private static final String FALLBACK_DEFAULT_BRANCH_NAME = "default";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PROBLEM_FALLBACK_BRANCH_NAME = "default-with-connector-problems";

    public static String determineProjectDefaultBranch(List<ConnectorDescriptorBase> connectors) {
        List<ICommitTreeConnectorDescriptor> repositoryConnectors = ProjectDefaultBranchUtils.selectRepositoryConnectors(connectors);
        if (repositoryConnectors.isEmpty()) {
            return FALLBACK_DEFAULT_BRANCH_NAME;
        }
        List<ICommitTreeConnectorDescriptor> branchingEnabledConnectors = ProjectDefaultBranchUtils.selectBranchingEnabledConnectors(connectors);
        if (branchingEnabledConnectors.isEmpty()) {
            return repositoryConnectors.getFirst().getTransformedDefaultBranchName();
        }
        return branchingEnabledConnectors.getFirst().getTransformedDefaultBranchName();
    }

    public static void setProjectDefaultBranch(IndexLayer indexLayer, boolean validateProject, String projectDefaultBranch, InternalProjectId internalId) throws StorageException, ProjectConfigurationException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)internalId);
        if (projectDefaultBranch == null) {
            ProjectDefaultBranchUtils.setProjectDefaultBranch(projectStorageSystem, FALLBACK_DEFAULT_BRANCH_NAME, "Failed to set fallback default branch");
            return;
        }
        try {
            ProjectDefaultBranchUtils.setProjectDefaultBranch(projectStorageSystem, projectDefaultBranch);
        }
        catch (StorageException e) {
            if (validateProject) {
                throw new ProjectConfigurationException("Failed to set project default branch: " + e.getMessage(), e);
            }
            LOGGER.warn("Failed to set pre-calculated default branch. Setting fallback: {}", (Object)PROBLEM_FALLBACK_BRANCH_NAME, (Object)e);
            ProjectDefaultBranchUtils.setProjectDefaultBranch(projectStorageSystem, PROBLEM_FALLBACK_BRANCH_NAME, "Failed to set '%s' fallback".formatted(PROBLEM_FALLBACK_BRANCH_NAME));
        }
    }

    private static void setProjectDefaultBranch(ProjectStorageSystem projectStorageSystem, String branchName, String errorMessage) throws ProjectConfigurationException {
        try {
            ProjectDefaultBranchUtils.setProjectDefaultBranch(projectStorageSystem, branchName);
        }
        catch (StorageException e) {
            throw new ProjectConfigurationException(errorMessage + ": " + e.getMessage(), e);
        }
    }

    private static List<ICommitTreeConnectorDescriptor> selectRepositoryConnectors(List<ConnectorDescriptorBase> connectorDescriptors) {
        return CollectionUtils.filterAndMap(connectorDescriptors, ICommitTreeConnectorDescriptor.class::isInstance, ICommitTreeConnectorDescriptor.class::cast);
    }

    private static List<ICommitTreeConnectorDescriptor> selectBranchingEnabledConnectors(List<ConnectorDescriptorBase> connectorDescriptors) {
        List<ICommitTreeConnectorDescriptor> repositoryConnectors = ProjectDefaultBranchUtils.selectRepositoryConnectors(connectorDescriptors);
        return CollectionUtils.filterAndMap(repositoryConnectors, ICommitTreeConnectorDescriptor::isBranchingEnabled, connector -> connector);
    }

    private static void setProjectDefaultBranch(ProjectStorageSystem projectStorageSystem, String defaultBranch) throws StorageException {
        ((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).setDefaultBranchName(defaultBranch);
    }

    private ProjectDefaultBranchUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

