/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.reflect.TypeConversionException;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass
public final class TriggerDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TRIGGER_CLASS_PROPERTY_NAME = "triggerClass";
    private static final String SCHEDULING_PARAMETERS_PROPERTY_NAME = "schedulingParameters";
    private static final String RESOLVED_INDEX_BY_PLACEHOLDER_PROPERTY_NAME = "resolvedIndexByPlaceholder";
    private static final String TRIGGER_PARAMETERS_PROPERTY_NAME = "triggerParameters";
    @JsonProperty(value="triggerClass")
    private final Class<? extends IAnalysisStep> triggerClass;
    @JsonProperty(value="schedulingParameters")
    private final Map<ESchedulingParameter, JsonNode> schedulingParameters = new EnumMap<ESchedulingParameter, JsonNode>(ESchedulingParameter.class);
    @JsonProperty(value="resolvedIndexByPlaceholder")
    private final Map<String, String> resolvedIndexByPlaceholder = new HashMap<String, String>();
    @JsonProperty(value="triggerParameters")
    private final Map<String, JsonNode> triggerParameters = new HashMap<String, JsonNode>();

    TriggerDescription(TriggerBuilder triggerBuilder) {
        this(triggerBuilder.getTriggerClass(), triggerBuilder.getSchedulingParameters(), triggerBuilder.getResolvedIndexByPlaceholder(), triggerBuilder.getTriggerParameters());
    }

    @JsonCreator
    @VisibleForTesting
    public TriggerDescription(@JsonProperty(value="triggerClass") Class<? extends IAnalysisStep> triggerClass, @JsonProperty(value="schedulingParameters") Map<ESchedulingParameter, JsonNode> schedulingParameters, @JsonProperty(value="resolvedIndexByPlaceholder") Map<String, String> resolvedIndexByPlaceholder, @JsonProperty(value="triggerParameters") Map<String, JsonNode> triggerParameters) {
        this.triggerClass = triggerClass;
        this.schedulingParameters.putAll(schedulingParameters);
        this.resolvedIndexByPlaceholder.putAll(resolvedIndexByPlaceholder);
        this.triggerParameters.putAll(triggerParameters);
    }

    public Class<? extends IAnalysisStep> getTriggerClass() {
        return this.triggerClass;
    }

    public Parameters<ESchedulingParameter> getSchedulingParameters() {
        return new Parameters<ESchedulingParameter>(this.schedulingParameters);
    }

    public UnmodifiableMap<String, String> getResolvedIndexByPlaceholder() {
        return CollectionUtils.asUnmodifiable(this.resolvedIndexByPlaceholder);
    }

    public Parameters<String> getTriggerParameters() {
        return new Parameters<String>(this.triggerParameters);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TriggerDescription)) {
            return false;
        }
        TriggerDescription that = (TriggerDescription)o;
        return Objects.equals(this.triggerClass, that.triggerClass) && Objects.equals(this.schedulingParameters, that.schedulingParameters) && Objects.equals(this.resolvedIndexByPlaceholder, that.resolvedIndexByPlaceholder) && Objects.equals(this.triggerParameters, that.triggerParameters);
    }

    public int hashCode() {
        return Objects.hash(this.triggerClass, this.schedulingParameters, this.resolvedIndexByPlaceholder, this.triggerParameters);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public static final class Parameters<K> {
        private final Map<K, JsonNode> parameters;

        private Parameters(Map<K, JsonNode> parameters) {
            this.parameters = parameters;
        }

        public UnmodifiableSet<K> getParameterKeys() {
            return CollectionUtils.asUnmodifiable(this.parameters.keySet());
        }

        public Optional<Parameter<K>> getParameter(K key) {
            return Optional.ofNullable(this.parameters.get(key)).map(value -> new Parameter<Object>(key, (JsonNode)value));
        }

        @VisibleForTesting
        public Map<K, JsonNode> getAllParameters() {
            return this.parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonNode)entry.getValue()).deepCopy()));
        }
    }

    public static final class Parameter<K> {
        private final K key;
        private final JsonNode value;

        private Parameter(K key, JsonNode value) {
            this.key = key;
            this.value = value;
        }

        public JsonNode getValue() {
            return this.value.deepCopy();
        }

        public <T> T as(TypeReference<T> type) throws TypeConversionException {
            try {
                return (T)JsonUtils.deserializeFromJson((TreeNode)this.value, type);
            }
            catch (JsonSerializationException e) {
                throw new TypeConversionException("Could not parse parameter %s to %s".formatted(this.key, type), (Throwable)e);
            }
        }

        public Object as(Type type) throws TypeConversionException {
            try {
                return JsonUtils.deserializeFromJson((TreeNode)this.value, (JavaType)JsonUtils.getObjectMapper().constructType(type));
            }
            catch (JsonSerializationException e) {
                throw new TypeConversionException("Could not parse parameter %s to %s".formatted(this.key, type), (Throwable)e);
            }
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

