/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass
public class ProjectBranchingConfiguration
implements MetaIndex.IMetaIndexEntry {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="branchConfigurations")
    @VisibleForTesting
    final List<BranchConfiguration> branchConfigurations = new ArrayList<BranchConfiguration>();

    public void checkConsistency() throws ProjectConfigurationException {
        BranchConfiguration lastBranchConfiguration = (BranchConfiguration)CollectionUtils.getLast(this.branchConfigurations);
        if (lastBranchConfiguration == null) {
            throw new ProjectConfigurationException("No branch configurations provided!");
        }
        if (!lastBranchConfiguration.branchNamePattern.equals(".*")) {
            throw new ProjectConfigurationException("The last pattern for branching configuration must match all branches, i.e. be '.*'!");
        }
        for (BranchConfiguration branchConfiguration : this.branchConfigurations) {
            try {
                Pattern.compile(branchConfiguration.branchNamePattern);
            }
            catch (PatternSyntaxException e) {
                throw new ProjectConfigurationException("Pattern '" + branchConfiguration.branchNamePattern + "' in branching configuration is not a valid regular expression: " + e.getMessage(), e);
            }
            branchConfiguration.getParsedDateOrThrowException();
        }
    }

    public Optional<BranchConfiguration> getBranchConfiguration(String branchName) {
        for (BranchConfiguration branchConfiguration : this.branchConfigurations) {
            if (!branchConfiguration.includesBranch(branchName)) continue;
            return Optional.of(branchConfiguration);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.branchConfigurations);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProjectBranchingConfiguration)) {
            return false;
        }
        ProjectBranchingConfiguration other = (ProjectBranchingConfiguration)obj;
        return Objects.equals(this.branchConfigurations, other.branchConfigurations);
    }

    public void addBranchConfiguration(BranchConfiguration branchConfiguration) {
        this.branchConfigurations.add(branchConfiguration);
    }

    public void storeStartDatesAsTimestamp() throws ProjectConfigurationException {
        for (BranchConfiguration branchConfiguration : this.branchConfigurations) {
            branchConfiguration.startTimestamp = branchConfiguration.getParsedDateOrThrowException().toInstant().toEpochMilli();
        }
    }

    public OptionalLong getMinimalStartTimestamp() {
        return this.branchConfigurations.stream().mapToLong(BranchConfiguration::getStartTimestamp).min();
    }

    public List<String> getRelativeStartDates() {
        return this.branchConfigurations.stream().map(branchConfiguration -> branchConfiguration.startDate).filter(ConnectorUtils::isRelativeDate).toList();
    }

    public int numberOfConfigurations() {
        return this.branchConfigurations.size();
    }

    @IndexValueClass
    public static class BranchConfiguration
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String BRANCH_NAME_PATTERN_PROPERTY = "branchNamePattern";
        private static final String START_DATE_PROPERTY = "startDate";
        @JsonProperty(value="branchNamePattern")
        private final String branchNamePattern;
        private transient Pattern compiledBranchNamePattern;
        @JsonProperty(value="startDate")
        private String startDate;
        @JsonIgnore
        private long startTimestamp;

        @JsonCreator
        public BranchConfiguration(@JsonProperty(value="branchNamePattern") String branchNamePattern, @JsonProperty(value="startDate") String startDate) {
            this.branchNamePattern = branchNamePattern;
            this.startDate = startDate;
        }

        private boolean includesBranch(String branchName) {
            if (this.compiledBranchNamePattern == null) {
                this.compiledBranchNamePattern = Pattern.compile(this.branchNamePattern);
            }
            return this.compiledBranchNamePattern.matcher(branchName).matches();
        }

        private ZonedDateTime getParsedDateOrThrowException() throws ProjectConfigurationException {
            return ConnectorUtils.parseDate(this.startDate).orElseThrow(() -> new ProjectConfigurationException("Date '" + this.startDate + "' for branch pattern '" + this.branchNamePattern + "' is not valid!"));
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        public int hashCode() {
            return Objects.hash(this.branchNamePattern, this.startDate);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BranchConfiguration)) {
                return false;
            }
            BranchConfiguration other = (BranchConfiguration)obj;
            return Objects.equals(this.branchNamePattern, other.branchNamePattern) && Objects.equals(this.startDate, other.startDate);
        }
    }
}

