/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.teamscale.commons.service.ServiceUtils;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectBranchingConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.connectors.ICommitTreeConnectorDescriptor;
import com.teamscale.core.concurrency.WrappedExecutorServiceProducer;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.ExternalStorageProjectMappingId;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@IndexValueClass
public class ProjectConfiguration
implements MetaIndex.IMetaIndexEntry {
    private static final long serialVersionUID = 1L;
    private static final String NAME_PROPERTY = "name";
    public static final String INTERNAL_ID_PROPERTY = "internalId";
    private static final String PUBLIC_IDS_PROPERTY = "publicIds";
    private static final String PARENT_PROJECT_ID_PROPERTY = "parentProjectId";
    private static final String EXTERNAL_STORAGE_PROJECT_MAPPING_ID_PROPERTY = "externalStorageProjectMappingId";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String PROPERTIES_PROPERTY = "properties";
    public static final String CODE_SCOPES_PROPERTY = "codeScopes";
    private static final String METRIC_THRESHOLD_CONFIGURATION_PROPERTY = "metricThresholdConfiguration";
    private static final String BRANCHING_CONFIGURATION_PROPERTY = "branchingConfiguration";
    public static final String CONNECTORS_PROPERTY = "connectors";
    private static final String EXTERNAL_STORAGE_BACKEND_PROPERTY = "externalStorageBackend";
    private static final String PRESELECTED_UI_BRANCH = "preselectedUIBranch";
    private static final int PARALLEL_CONNECTOR_VALIDATIONS_NUMBER = 10;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="internalId")
    private @Nullable InternalProjectId internalId;
    @JsonProperty(value="externalStorageProjectMappingId")
    private final @Nullable ExternalStorageProjectMappingId externalStorageProjectMappingId;
    @JsonProperty(value="publicIds")
    private List<PublicProjectId> publicIds;
    @JsonProperty(value="parentProjectId")
    private @Nullable IProjectId parentProjectId;
    @JsonProperty(value="description")
    private @Nullable String description;
    @JsonProperty(value="properties")
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    @JsonProperty(value="codeScopes")
    private List<CodeScope> codeScopes;
    @JsonProperty(value="metricThresholdConfiguration")
    private @Nullable MetricThresholdConfiguration metricThresholdConfiguration;
    @JsonProperty(value="branchingConfiguration")
    private @Nullable ProjectBranchingConfiguration branchingConfiguration;
    @JsonProperty(value="externalStorageBackend")
    private @Nullable String externalStorageBackend;
    @JsonProperty(value="connectors")
    private final List<ConnectorConfiguration> connectors = new ArrayList<ConnectorConfiguration>();
    @JsonProperty(value="preselectedUIBranch")
    private @Nullable String preselectedUIBranch;
    private static final ExecutorService EXECUTOR_SERVICE = WrappedExecutorServiceProducer.newFixedThreadPool(10);

    public @Nullable String getPreselectedUIBranch() {
        return this.preselectedUIBranch;
    }

    @JsonCreator
    public ProjectConfiguration(@JsonProperty(value="name") String name, @JsonProperty(value="internalId") @Nullable InternalProjectId internalId, @JsonProperty(value="externalStorageProjectMappingId") @Nullable ExternalStorageProjectMappingId externalStorageProjectMappingId, @JsonProperty(value="publicIds") List<PublicProjectId> publicIds, @JsonProperty(value="codeScopes") @Nullable List<CodeScope> codeScopes, @JsonProperty(value="externalStorageBackend") @Nullable String externalStorageBackend) {
        this.name = name;
        this.internalId = Objects.requireNonNullElseGet(internalId, InternalProjectId::create);
        this.externalStorageProjectMappingId = Objects.requireNonNullElseGet(externalStorageProjectMappingId, ExternalStorageProjectMappingId::create);
        this.setPublicIds(publicIds);
        this.codeScopes = codeScopes;
        this.externalStorageBackend = externalStorageBackend;
    }

    @VisibleForTesting
    public ProjectConfiguration(String name, PublicProjectId publicId, @Nullable String profile) {
        this.name = name;
        this.internalId = InternalProjectId.create();
        this.externalStorageProjectMappingId = ExternalStorageProjectMappingId.create();
        this.externalStorageBackend = null;
        this.codeScopes = List.of(CodeScope.createCatchAllCodeScope(profile));
        this.setPublicIds(List.of(publicId));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @TestOnly
    public void setPreselectedUIBranch(String preselectedUIBranch) {
        this.preselectedUIBranch = preselectedUIBranch;
    }

    public UnmodifiableList<PublicProjectId> getPublicIds() {
        return CollectionUtils.asUnmodifiable(this.publicIds);
    }

    public PublicProjectId getPrimaryPublicId() {
        return this.publicIds.getFirst();
    }

    public void setPublicIds(List<PublicProjectId> publicIds) {
        Preconditions.checkState((!CollectionUtils.isNullOrEmpty(publicIds) ? 1 : 0) != 0, (Object)"At least one public ID needs to be provided.");
        this.publicIds = publicIds;
    }

    public @Nullable IProjectId getParentProjectId() {
        return this.parentProjectId;
    }

    public ExternalStorageProjectMappingId getExternalStorageProjectMappingId() {
        CCSMAssert.isNotNull((Object)this.externalStorageProjectMappingId, (String)"External storage project mapping ID was not initialized!");
        return this.externalStorageProjectMappingId;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = Objects.requireNonNull(properties, "Properties cannot be null");
    }

    public InternalProjectId getInternalId() {
        return Objects.requireNonNull(this.internalId, "Internal project ID should only be nullable for frontend.");
    }

    public @Nullable String getAnalysisProfileName(CodeScopeName codeScopeName) {
        return this.getCodeScopeByName(codeScopeName).getProfile();
    }

    public void setAnalysisProfileName(@Nullable String profile, CodeScopeName codeScopeName) {
        CodeScope scope = this.getCodeScopeByName(codeScopeName);
        if (profile == null) {
            CCSMAssert.isNotNull((Object)scope.getEmbeddedProfile());
        }
        scope.setProfile(profile);
    }

    @Deprecated
    public @Nullable AnalysisProfile getEmbeddedDefaultProfile() {
        return this.getEmbeddedProfile(CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    public @Nullable AnalysisProfile getEmbeddedProfile(CodeScopeName codeScopeName) {
        return this.getCodeScopeByName(codeScopeName).getEmbeddedProfile();
    }

    @Deprecated
    public void setEmbeddedDefaultProfile(@Nullable AnalysisProfile embeddedProfile) {
        this.setEmbeddedProfile(embeddedProfile, CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    public void setEmbeddedProfile(@Nullable AnalysisProfile embeddedProfile, CodeScopeName codeScopeName) {
        this.getCodeScopeByName(codeScopeName).setEmbeddedProfile(embeddedProfile);
    }

    public List<CodeScope> getCodeScopes() {
        return this.codeScopes;
    }

    public SequencedSet<CodeScopeName> getCodeScopeNames() {
        return this.codeScopes.stream().map(CodeScope::getName).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private @NonNull CodeScope getCodeScopeByName(CodeScopeName codeScopeName) {
        CodeScope detectedCodeScope = this.getCodeScope(codeScopeName);
        CCSMAssert.isNotNull((Object)detectedCodeScope, (String)"expected code scope '%s' to not be null".formatted(codeScopeName));
        return detectedCodeScope;
    }

    private @Nullable CodeScope getCodeScope(CodeScopeName codeScopeName) {
        return this.codeScopes.stream().filter(scope -> scope.getName().equals((Object)codeScopeName)).findFirst().orElse(null);
    }

    public UnmodifiableList<ConnectorConfiguration> getConnectors() {
        return CollectionUtils.asUnmodifiable(this.connectors);
    }

    public List<ConnectorConfiguration> getConnectorsByType(IConnectorEnum<?> connectorType) {
        return CollectionUtils.filter(this.getConnectors(), config -> config.getRawType().equals(connectorType.getReadableName()));
    }

    public List<ConnectorConfiguration> getConnectorsByNames(Set<String> connectorNames) {
        return CollectionUtils.filter(this.getConnectors(), config -> connectorNames.contains(config.getRawType()));
    }

    public ConnectorConfiguration getConnectorByIdentifier(String identifier) {
        return (ConnectorConfiguration)Iterables.getOnlyElement((Iterable)CollectionUtils.filter(this.getConnectors(), config -> config.getIdentifier().equals(identifier)));
    }

    public void addConnector(ConnectorConfiguration connector) {
        this.connectors.add(connector);
    }

    public void setMetricThresholdConfiguration(@Nullable MetricThresholdConfiguration metricThresholdConfiguration) {
        this.metricThresholdConfiguration = metricThresholdConfiguration;
    }

    public @Nullable String getExternalStorageBackend() {
        return this.externalStorageBackend;
    }

    public void setExternalStorageBackend(@Nullable String externalStorageBackend) {
        this.externalStorageBackend = externalStorageBackend;
    }

    public Optional<String> validateIdentifiers() {
        StringJoiner errorMessageJoiner = new StringJoiner(", ");
        for (PublicProjectId publicId : this.publicIds) {
            ServiceUtils.getErrorMessageForInvalidIdentifiers((String)publicId.toString(), (String)"ID").ifPresent(errorMessageJoiner::add);
        }
        if (new HashSet<PublicProjectId>(this.publicIds).size() != this.publicIds.size()) {
            errorMessageJoiner.add("Primary project ID and all alternative project IDs must differ.");
        }
        ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.getName(), (String)"Name").ifPresent(errorMessageJoiner::add);
        if (this.parentProjectId != null) {
            ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.getName(), (String)"Name").ifPresent(errorMessageJoiner::add);
        }
        if (this.externalStorageProjectMappingId != null) {
            ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.externalStorageProjectMappingId.toString(), (String)"External Storage Project Mapping ID").ifPresent(errorMessageJoiner::add);
        }
        if (this.externalStorageBackend != null) {
            ServiceUtils.getErrorMessageForInvalidIdentifiers((String)this.externalStorageBackend, (String)"External Storage Backend").ifPresent(errorMessageJoiner::add);
        }
        if (errorMessageJoiner.length() > 0) {
            return Optional.of(errorMessageJoiner.toString());
        }
        return Optional.empty();
    }

    public @Nullable ProjectBranchingConfiguration getBranchingConfiguration() {
        return this.branchingConfiguration;
    }

    public void setBranchingConfiguration(@Nullable ProjectBranchingConfiguration branchingConfiguration) {
        this.branchingConfiguration = branchingConfiguration;
    }

    public void setDefaultBranchingConfiguration() {
        this.setBranchingConfiguration(ProjectConfiguration.createDefaultBranchingConfiguration());
    }

    private static @NonNull ProjectBranchingConfiguration createDefaultBranchingConfiguration() {
        ProjectBranchingConfiguration branchingConfiguration = new ProjectBranchingConfiguration();
        branchingConfiguration.addBranchConfiguration(new ProjectBranchingConfiguration.BranchConfiguration("main|master|trunk|release.*", "1 year"));
        branchingConfiguration.addBranchConfiguration(new ProjectBranchingConfiguration.BranchConfiguration(".*", "3 months"));
        return branchingConfiguration;
    }

    public void validate(IndexLayer indexLayer, @Nullable String username, boolean hasExternalStorageBackend) throws ProjectConfigurationException, StorageException {
        CodeScope defaultCodeScope = this.getCodeScope(CodeScopeAware.DEFAULT_CODE_SCOPE);
        if (defaultCodeScope == null) {
            throw new ProjectConfigurationException("Default code scope is missing.");
        }
        CodeScopeAware<AnalysisProfile> analysisProfilePerScope = this.getAnalysisProfilePerScope(indexLayer.openGlobalIndex(AnalysisProfileIndex.class));
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)((Object)SerializationUtils.cloneBySerialization((Serializable)((Object)this)));
        CCSMAssert.isNotNull((Object)projectConfiguration);
        for (CodeScopeName codeScopeName : analysisProfilePerScope.getCodeScopeNames()) {
            projectConfiguration.setEmbeddedProfile(analysisProfilePerScope.getValue(codeScopeName), codeScopeName);
            projectConfiguration.setAnalysisProfileName(null, codeScopeName);
        }
        if (projectConfiguration.branchingConfiguration == null) {
            throw new ProjectConfigurationException("Branching configuration missing.");
        }
        projectConfiguration.branchingConfiguration.checkConsistency();
        this.validateParentProject(indexLayer);
        List<ConnectorDescriptorBase> connectors = ProjectConfiguration.retrieveConnectors(indexLayer, username, projectConfiguration, true, hasExternalStorageBackend);
        this.validateRepositoryConnectorConfiguration(connectors);
    }

    private void validateParentProject(IndexLayer indexLayer) throws StorageException, ProjectConfigurationException {
        IProjectId parentProjectId = this.getParentProjectId();
        if (parentProjectId == null) {
            return;
        }
        ProjectIndex projectIndex = indexLayer.openGlobalIndex(ProjectIndex.class);
        ProjectInfo parentProjectInfo = projectIndex.resolveProject(parentProjectId);
        if (parentProjectInfo.getParentProjectId().isPresent()) {
            throw new ProjectConfigurationException("Can't use project that has a parent project itself as the parent project.");
        }
    }

    private static List<ICommitTreeConnectorDescriptor> selectRepositoryConnectors(List<ConnectorDescriptorBase> connectorDescriptors) {
        return CollectionUtils.filterAndMap(connectorDescriptors, ICommitTreeConnectorDescriptor.class::isInstance, ICommitTreeConnectorDescriptor.class::cast);
    }

    private void validateRepositoryConnectorConfiguration(List<ConnectorDescriptorBase> connectorDescriptors) throws ProjectConfigurationException {
        List<ICommitTreeConnectorDescriptor> repositoryConnectors = ProjectConfiguration.selectRepositoryConnectors(connectorDescriptors);
        if (repositoryConnectors.isEmpty()) {
            return;
        }
        ProjectConfiguration.validateDefaultBranchCompatibility(repositoryConnectors);
        this.validatePreselectedUIBranch(repositoryConnectors);
    }

    private static void validateDefaultBranchCompatibility(List<ICommitTreeConnectorDescriptor> repositoryConnectors) throws ProjectConfigurationException {
        List<ICommitTreeConnectorDescriptor> branchingEnabledConnectors = ProjectConfiguration.selectBranchingEnabledConnectors(repositoryConnectors);
        if (branchingEnabledConnectors.size() < 2) {
            return;
        }
        Set<String> defaultBranches = ProjectConfiguration.extractTransformedDefaultBranches(branchingEnabledConnectors);
        if (defaultBranches.size() > 1) {
            throw new ProjectConfigurationException(ProjectConfiguration.createBranchInconsistencyMessage(defaultBranches));
        }
    }

    @VisibleForTesting
    public void validatePreselectedUIBranch(List<ICommitTreeConnectorDescriptor> repositoryConnectors) throws ProjectConfigurationException {
        String preselectedUIBranchName = this.getPreselectedUIBranch();
        if (preselectedUIBranchName == null) {
            return;
        }
        for (ICommitTreeConnectorDescriptor descriptor : repositoryConnectors) {
            try {
                boolean hasPreselectedUIBranch = descriptor.hasPreselectedUIBranch(preselectedUIBranchName);
                if (!hasPreselectedUIBranch) continue;
                return;
            }
            catch (ConnectorValidationException connectorValidationException) {
                throw new ProjectConfigurationException("Could not validate preselected UI branch due to exception in '" + ((ConnectorDescriptorBase)((Object)descriptor)).getName() + "': " + connectorValidationException.getMessage(), connectorValidationException);
            }
        }
        throw new ProjectConfigurationException("There is no branch that matches the preselected UI branch '" + preselectedUIBranchName + "'. Has the specified branch been transformed?");
    }

    private static List<ICommitTreeConnectorDescriptor> selectBranchingEnabledConnectors(List<ICommitTreeConnectorDescriptor> repositoryConnectors) {
        return CollectionUtils.filter(repositoryConnectors, ICommitTreeConnectorDescriptor::isBranchingEnabled);
    }

    private static Set<String> extractTransformedDefaultBranches(List<ICommitTreeConnectorDescriptor> branchingEnabledConnectors) {
        return CollectionUtils.mapToSet(branchingEnabledConnectors, ProjectConfiguration::getTransformedDefaultBranch);
    }

    private static String getTransformedDefaultBranch(ICommitTreeConnectorDescriptor connector) {
        return connector.getBranchTransformation().applyWithoutMatchingEmptyString(connector.getDefaultBranchName());
    }

    private static String createBranchInconsistencyMessage(Set<String> defaultBranches) {
        return "Since Teamscale offers a unified view of multiple repository connectors, their respective default branch settings need to be consistent over the scope of a single project. Resolve this error by using a single, consistent value for all default branches configured in your project. Please choose one of %s".formatted(defaultBranches);
    }

    public static List<ConnectorDescriptorBase> retrieveConnectors(IndexLayer indexLayer, @Nullable String username, ProjectConfiguration projectConfig, boolean validateConnectors, boolean hasExternalStorageBackend) throws ProjectConfigurationException, StorageException {
        ConfigurationInitializationContext context = new ConfigurationInitializationContext(username, indexLayer, indexLayer.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.PROJECT_CREATION);
        List<Callable<ConnectorDescriptorBase>> connectorDescriptorCallables = ProjectConfiguration.getConnectorValidations(projectConfig, validateConnectors, context);
        try {
            List connectorDescriptors = CollectionUtils.mapWithException(EXECUTOR_SERVICE.invokeAll(connectorDescriptorCallables), Future::get);
            if (validateConnectors) {
                ConnectorUtils.validateConnectorConsistency(connectorDescriptors, hasExternalStorageBackend, projectConfig.getPublicIds());
            }
            return connectorDescriptors;
        }
        catch (ProjectConfigurationException e) {
            throw e;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ProjectConfigurationException) {
                ProjectConfigurationException pce = (ProjectConfigurationException)throwable;
                throw pce;
            }
            throw new ProjectConfigurationException(e.getCause());
        }
        catch (Exception e) {
            throw new ProjectConfigurationException(e);
        }
    }

    private static @NonNull List<Callable<ConnectorDescriptorBase>> getConnectorValidations(ProjectConfiguration projectConfig, boolean validateConnectors, ConfigurationInitializationContext context) {
        ArrayList<Callable<ConnectorDescriptorBase>> connectorDescriptorCallables = new ArrayList<Callable<ConnectorDescriptorBase>>();
        UnmodifiableList<ConnectorConfiguration> connectors = projectConfig.getConnectors();
        int i = 0;
        while (i < connectors.size()) {
            int connectorIndex = i++;
            ConnectorConfiguration connector = (ConnectorConfiguration)connectors.get(connectorIndex);
            connectorDescriptorCallables.add(() -> {
                ConnectorDescriptorBase connectorDescriptor = ConnectorUtils.loadConnector(connector, context, projectConfig.internalId);
                if (validateConnectors) {
                    ConnectorUtils.validateConnector(connectorDescriptor, connectorIndex);
                }
                return connectorDescriptor;
            });
        }
        return connectorDescriptorCallables;
    }

    public ProjectConfiguration withPublicParentId(ProjectIndex projectIndex) throws StorageException {
        if (this.parentProjectId == null) {
            return this;
        }
        if (!this.parentProjectId.isInternal()) {
            return this;
        }
        Optional<ProjectInfo> projectInfo = projectIndex.tryResolveProject(this.parentProjectId);
        if (projectInfo.isEmpty()) {
            return this;
        }
        ProjectConfiguration projectConfiguration = this.copyProjectConfiguration();
        projectConfiguration.parentProjectId = projectInfo.get().getPrimaryPublicId();
        return projectConfiguration;
    }

    public ProjectConfiguration withInternalParentId(IndexLayer indexLayer) throws StorageException {
        if (this.parentProjectId == null) {
            return this;
        }
        if (this.parentProjectId.isInternal()) {
            return this;
        }
        ProjectConfiguration configurationCopy = this.copyProjectConfiguration();
        configurationCopy.parentProjectId = indexLayer.resolveToInternalProjectId(this.parentProjectId);
        return configurationCopy;
    }

    private ProjectConfiguration copyProjectConfiguration() {
        ProjectConfiguration projectConfiguration = new ProjectConfiguration(this.name, this.internalId, this.externalStorageProjectMappingId, this.publicIds, this.codeScopes, this.externalStorageBackend);
        projectConfiguration.description = this.description;
        projectConfiguration.metricThresholdConfiguration = this.metricThresholdConfiguration;
        projectConfiguration.branchingConfiguration = this.branchingConfiguration;
        projectConfiguration.connectors.addAll(this.connectors);
        return projectConfiguration;
    }

    public CodeScopeAware<AnalysisProfile> getAnalysisProfilePerScope(AnalysisProfileIndex profileIndex) throws StorageException, ProjectConfigurationException {
        List<String> analysisProfileNames = this.getAnalysisProfileNames().stream().toList();
        List<AnalysisProfile> analysisProfiles = profileIndex.getProfiles(analysisProfileNames, true);
        CodeScopeAware<AnalysisProfile> profilePerCodeScope = CodeScopeAware.empty();
        for (CodeScope codeScope : this.codeScopes) {
            AnalysisProfile analysisProfile = analysisProfiles.stream().filter(profile -> profile.getName().equals(ProjectConfiguration.getProfile(codeScope))).findFirst().orElseThrow(() -> new ProjectConfigurationException("no analysis profile found for code scope '%s'".formatted(codeScope.getName())));
            profilePerCodeScope.setValue(codeScope.getName(), analysisProfile);
        }
        return profilePerCodeScope;
    }

    public List<CodeScopeName> getCodeScopeNamesForAnalysisProfile(String analysisProfileName) {
        return this.codeScopes.stream().filter(codeScope -> {
            CCSMAssert.isNotNull((Object)codeScope.getEmbeddedProfile());
            return codeScope.getEmbeddedProfile().getName().equals(analysisProfileName);
        }).map(CodeScope::getName).toList();
    }

    public Set<@NonNull ELanguage> getConfiguredLanguages() {
        return this.getConfigured(AnalysisProfile::getLanguages);
    }

    public Set<@NonNull EAnalysisTool> getConfiguredTools() {
        return this.getConfigured(AnalysisProfile::getTools);
    }

    private <T> Set<T> getConfigured(Function<AnalysisProfile, UnmodifiableSet<T>> itemAccessor) {
        HashSet<@NonNull E> configuredItems = new HashSet();
        for (CodeScope codeScope : this.codeScopes) {
            AnalysisProfile embeddedProfile = codeScope.getEmbeddedProfile();
            if (embeddedProfile == null) continue;
            configuredItems.addAll((Collection)itemAccessor.apply(embeddedProfile));
        }
        return configuredItems;
    }

    public Set<@NonNull String> getAnalysisProfileNames() {
        return this.codeScopes.stream().map(ProjectConfiguration::getProfile).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static String getProfile(CodeScope codeScope) {
        if (codeScope.getProfile() == null) {
            return Objects.requireNonNull(codeScope.getEmbeddedProfile()).getName();
        }
        return codeScope.getProfile();
    }
}

