/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.InheritedConfigs;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorModuleBase;
import com.teamscale.core.analysis.configuration.model.connectors.ExposeConnectorModule;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentialsOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.AppleA3ConnectorOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.AppleA3Option;
import com.teamscale.core.analysis.configuration.model.option.BooleanOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.BooleanValuePairListOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionLanguages;
import com.teamscale.core.analysis.configuration.model.option.EnumOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.GitHubRepositoryConnectorOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.GitHubRepositoryConnectorUrl;
import com.teamscale.core.analysis.configuration.model.option.JiraIssueUpdateConfiguration;
import com.teamscale.core.analysis.configuration.model.option.JiraIssueUpdateConfigurationOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.JsonOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.NumberOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.NumericThresholds;
import com.teamscale.core.analysis.configuration.model.option.NumericThresholdsOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.SapSystemConnection;
import com.teamscale.core.analysis.configuration.model.option.SapSystemConnectionOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.StringListOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.StringOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.StringSetOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.StringValuePairListOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.critical_change.CriticalChangeBadgeConfigurationOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.critical_change.CriticalChangeBadgesConfiguration;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgeConfigurationOptionDescriptor;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfiguration;
import eu.cqse.check.framework.scanner.ELanguage;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jspecify.annotations.NonNull;

public abstract class ConfigurationBase {
    protected static final String COMMENTS_TOOLTIP = "\nLines starting with '##' are ignored.";
    protected static final String ESCAPE_IN_JAVA_REGEX_HINT = "\nMake sure to escape reserved characters like '(', ')' or '.' as well as commas properly with the escape character '\\\\'. ";
    @JsonIgnore
    private final Set<ConfigOptionDescriptorBase> allOptions = new HashSet<ConfigOptionDescriptorBase>();
    @JsonProperty(value="options")
    private final ArrayList<ConfigOptionDescriptorBase> visibleOptions = new ArrayList();
    @JsonIgnore
    private final Set<String> hiddenOptions = new HashSet<String>();
    @JsonIgnore
    private final InheritedConfigs inheritedConfigs = new InheritedConfigs();
    @JsonProperty(value="optionLookup")
    protected final CodeScopeAware<Map<String, ConfigOptionDescriptorBase>> optionLookup = CodeScopeAware.empty();
    @JsonIgnore
    private final Set<ConnectorModuleBase> connectorModules = new HashSet<ConnectorModuleBase>();

    public UnmodifiableList<ConfigOptionDescriptorBase> getVisibleOptions() {
        return CollectionUtils.asUnmodifiable(this.visibleOptions);
    }

    public UnmodifiableSet<ConfigOptionDescriptorBase> getAllOptions() {
        return CollectionUtils.asUnmodifiable(this.allOptions);
    }

    protected UnmodifiableSet<ConnectorModuleBase> getConnectorModules() {
        return CollectionUtils.asUnmodifiable(this.connectorModules);
    }

    public ConfigOptionDescriptorBase getOption(String optionName) {
        return this.allOptions.stream().filter(o -> o.getName().equals(optionName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No option with the given name " + optionName + " found"));
    }

    protected void addOption(ConfigOptionDescriptorBase option) {
        ((ConfigurationItemBase)option).setConfiguration(this);
        this.overwriteOrAddOption(option);
    }

    private void overwriteOrAddOption(ConfigOptionDescriptorBase option) {
        this.allOptions.add(option);
        if (this.hiddenOptions.contains(option.getName())) {
            return;
        }
        for (int i = 0; i < this.visibleOptions.size(); ++i) {
            if (!this.visibleOptions.get(i).getName().equals(option.getName())) continue;
            this.visibleOptions.set(i, option);
            return;
        }
        this.visibleOptions.add(option);
    }

    public final void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.configureProjectInternal(proxy);
        for (ConfigurationBase configurationBase : this.connectorModules) {
            configurationBase.configureProjectInternal(proxy);
        }
    }

    protected abstract void configureProjectInternal(ProjectCreationProxy var1) throws ProjectConfigurationException;

    protected void autoExpose(CodeScopeName codeScopeName) {
        Deque<Class<?>> classes = this.buildClassHierarchy();
        classes.forEach(cl -> this.autoExpose(codeScopeName, (Class<?>)cl));
    }

    private @NonNull Deque<Class<?>> buildClassHierarchy() {
        ArrayDeque classes = new ArrayDeque();
        for (Class<?> clazz = this.getClass(); clazz != null && clazz != Object.class && clazz != ConfigurationBase.class; clazz = clazz.getSuperclass()) {
            classes.addFirst(clazz);
        }
        return classes;
    }

    protected void autoExpose() {
        this.autoExpose(CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    private void autoExpose(CodeScopeName codeScopeName, Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            try {
                this.exposeField(codeScopeName, field);
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                throw new AssertionError("Error processing field " + String.valueOf(field) + ": " + e.getMessage(), e);
            }
        }
        this.inheritedConfigs.injectInheritedConfigs(codeScopeName, this.allOptions);
    }

    protected final void autoExpose(CodeScopeName codeScopeName, Set<ELanguage> languages) {
        Deque<Class<?>> classes = this.buildClassHierarchy();
        classes.forEach(cl -> this.autoExpose(codeScopeName, (Class<?>)cl));
        ArrayList fields = new ArrayList();
        for (Class<?> clazz : classes) {
            Collections.addAll(fields, clazz.getDeclaredFields());
        }
        for (Field field : fields) {
            try {
                if (field.isAnnotationPresent(ConfigExposed.class) && field.isAnnotationPresent(ConfigOptionLanguages.class)) {
                    if (Arrays.stream(field.getAnnotation(ConfigOptionLanguages.class).languages()).noneMatch(languages::contains)) continue;
                }
                this.exposeField(codeScopeName, field);
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                CCSMAssert.fail((String)("Error processing field " + String.valueOf(field) + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void exposeField(CodeScopeName codeScopeName, Field field) throws ReflectiveOperationException {
        field.setAccessible(true);
        this.inheritedConfigs.collect(this, field);
        if (field.isAnnotationPresent(ExposeConnectorModule.class)) {
            this.exposeConnectorModule(codeScopeName, field);
        }
        if (field.isAnnotationPresent(ConfigExposed.class)) {
            this.exposeConfigExposedField(codeScopeName, field);
        }
    }

    private void exposeConnectorModule(CodeScopeName codeScopeName, Field field) throws IllegalAccessException {
        ConfigurationBase module = this.getConnectorModuleFieldInstance(field);
        module.autoExpose(codeScopeName, field.getType());
        this.hiddenOptions.addAll(module.hiddenOptions);
        this.inheritedConfigs.addAll(module.inheritedConfigs);
        module.getAllOptions().forEach(this::addOption);
    }

    private void exposeConfigExposedField(CodeScopeName codeScopeName, Field field) {
        ConfigExposed annotation = field.getAnnotation(ConfigExposed.class);
        ConfigOptionDescriptorBase optionDescriptor = ConfigurationBase.wrapOptionField(field, annotation);
        if (!this.optionLookup.contains(codeScopeName)) {
            this.optionLookup.setValue(codeScopeName, new HashMap());
        }
        this.optionLookup.getValue(codeScopeName).put(field.getName(), optionDescriptor);
        this.addOption(optionDescriptor);
    }

    private ConfigurationBase getConnectorModuleFieldInstance(Field field) throws IllegalAccessException {
        Object o = field.get(this);
        if (o == null) {
            throw new IllegalArgumentException("Fields annotated with '@%s' must be initialized on construction.".formatted(ExposeConnectorModule.class.getSimpleName()));
        }
        if (!(o instanceof ConnectorModuleBase)) {
            throw new IllegalArgumentException("Type '%s' must extend '%s' to be annotated with '@%s'.".formatted(field.getType().getName(), ConnectorModuleBase.class.getSimpleName(), ExposeConnectorModule.class.getSimpleName()));
        }
        ConnectorModuleBase module = (ConnectorModuleBase)o;
        this.connectorModules.add(module);
        return module;
    }

    private static ConfigOptionDescriptorBase wrapOptionField(Field field, ConfigExposed annotation) {
        Class type = field.getType();
        Type genericType = field.getGenericType();
        if (type == CodeScopeAware.class) {
            Type actualTypeArgument;
            CCSMAssert.isTrue((boolean)(genericType instanceof ParameterizedType), (String)"the generic type of an exposed code scope configuration needs to be an instance of ParameterizedType");
            genericType = actualTypeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (actualTypeArgument instanceof ParameterizedType) {
                actualTypeArgument = ((ParameterizedType)actualTypeArgument).getRawType();
            }
            type = (Class)actualTypeArgument;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return new BooleanOptionDescriptor(annotation, field);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new NumberOptionDescriptor<Integer>(annotation, field, Integer::valueOf);
        }
        if (type == Long.TYPE || type == Long.class) {
            return new NumberOptionDescriptor<Long>(annotation, field, Long::valueOf);
        }
        if (type == String.class) {
            return new StringOptionDescriptor(annotation, field);
        }
        if (type == NumericThresholds.class) {
            return new NumericThresholdsOptionDescriptor(annotation, field);
        }
        if (type == AccountCredentials.class) {
            return new AccountCredentialsOptionDescriptor(annotation, field);
        }
        if (type == GitHubRepositoryConnectorUrl.class) {
            return new GitHubRepositoryConnectorOptionDescriptor(annotation, field);
        }
        if (type == JiraIssueUpdateConfiguration.class) {
            return new JiraIssueUpdateConfigurationOptionDescriptor(annotation, field);
        }
        if (type == MetricBadgesConfiguration.class) {
            return new MetricBadgeConfigurationOptionDescriptor(annotation, field);
        }
        if (type == CriticalChangeBadgesConfiguration.class) {
            return new CriticalChangeBadgeConfigurationOptionDescriptor(annotation, field);
        }
        if (type == PairList.class) {
            return ConfigurationBase.wrapPairListField(field, annotation, genericType);
        }
        if (type == SapSystemConnection.class) {
            return new SapSystemConnectionOptionDescriptor(annotation, field);
        }
        if (type == JsonNode.class) {
            return new JsonOptionDescriptor(annotation, field);
        }
        if (type == AppleA3Option.class) {
            return new AppleA3ConnectorOptionDescriptor(annotation, field);
        }
        if (List.class.isAssignableFrom(type)) {
            return new StringListOptionDescriptor(annotation, field);
        }
        if (Set.class.isAssignableFrom(type)) {
            return new StringSetOptionDescriptor(annotation, field);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return new EnumOptionDescriptor(annotation, field);
        }
        throw new AssertionError((Object)("Unsupported option type: " + String.valueOf(type)));
    }

    private static ConfigOptionDescriptorBase wrapPairListField(Field field, ConfigExposed annotation, Type pairListType) throws AssertionError {
        CCSMAssert.isInstanceOf((Object)pairListType, ParameterizedType.class);
        ParameterizedType genericType = (ParameterizedType)pairListType;
        Type[] typeParameters = genericType.getActualTypeArguments();
        CCSMAssert.isTrue((typeParameters.length == 2 ? 1 : 0) != 0, (String)"PairList takes two generic arguments!");
        CCSMAssert.isTrue((typeParameters[0] == String.class ? 1 : 0) != 0, (String)("Expected first generic parameter to be a string for field " + field.getName()));
        if (typeParameters[1] == String.class) {
            return new StringValuePairListOptionDescriptor(annotation, field);
        }
        if (typeParameters[1] == Boolean.class) {
            return new BooleanValuePairListOptionDescriptor(annotation, field);
        }
        throw new AssertionError((Object)("Unsupported type for second type parameter of PairList in: " + String.valueOf(field)));
    }

    protected void hideOption(String name) {
        this.hiddenOptions.add(name);
        this.visibleOptions.removeIf(option -> option.getName().equals(name));
    }

    public CodeScopeAware<?> getCodeScopeObject(String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = this.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        Object codeScopeParam = field.get(this);
        CCSMAssert.isTrue((boolean)(codeScopeParam instanceof CodeScopeAware), (String)"field '%s' needs to be of type CodeScopeAware".formatted(fieldName));
        return (CodeScopeAware)codeScopeParam;
    }
}

